/*
 * Decompiled with CFR 0.152.
 */
import edu.neu.ccs.demeterf.demfgen.lib.List;
import java.util.Random;

public class ListTest {
    Random r = new Random();
    int fails = 0;
    int total = 0;

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.err.println(" usage: ListTest <length>");
            System.exit(1);
        }
        int n2 = Integer.parseInt(stringArray[0]);
        new ListTest().main(n2);
    }

    void main(int n2) {
        List<Integer> list = List.buildlist(new List.Build<Integer>(){

            @Override
            public Integer build(int n2) {
                return n2;
            }
        }, n2);
        int n3 = this.r.nextInt(n2);
        this.test("Length", list.length() == n2);
        this.print("Map-Add1", list.map(new List.Map<Integer, Integer>(){

            @Override
            public Integer map(Integer n2) {
                return n2 + 1;
            }
        }), n2);
        this.print("Append-List", list.append((Integer)((Object)List.create(n2, n2 + 1, n2 + 2))), n2);
        this.print("Append-Element", list.append(n2), n2);
        this.test("Contains", list.contains(n2 - 1));
        this.test("Contains", list.contains(n3));
        this.test("Contains", list.contains(new Odd()));
        this.test("Contains", list.contains(new Even()));
        this.test("ContainsAny", list.containsAny(List.create(1, 3, 5)));
        this.test("ContainsAny", !list.containsAny(List.create(-1, -3, -5)));
        this.test("ContainsAll-#t", list.containsAll(List.create(1, 3, 5)));
        this.test("ContainsAll-#f", !list.containsAll(List.create(-1, 3, 5)));
        this.test("Find", n3 == list.find(n3));
        this.print("Remove", list.remove(n3), n2);
        this.test("lookup-" + n3 + ":" + list.lookup(n3), n3 == list.lookup(n3));
        this.test("lookup-0", 0 == list.lookup(0));
        this.print("toString", list.toString(", ", ""), n2);
        this.print("toString", list.toString(":", " #"), n2);
        this.print("Filter-Odd", list.filter(new Odd()), n2);
        this.print("Filter-Even", list.filter(new Even()), n2);
        this.print("foldl:sum:" + n2 * (n2 - 1) / 2, list.foldl(new List.Fold<Integer, Long>(){

            @Override
            public Long fold(Integer n2, Long l2) {
                return (long)n2.intValue() + l2;
            }
        }, 0L), n2);
        this.print("foldr:fact", list.pop().foldr(new List.Fold<Integer, Long>(){

            @Override
            public Long fold(Integer n2, Long l2) {
                return (long)n2.intValue() * l2;
            }
        }, 1L), n2);
        this.print("add", list.add(99, 3), n2);
        this.print("remove", list.remove(3), n2);
        this.print("sort", List.create(2, 3, 1, 5, 2, 65, 26, 34, 27, 1).sort(new List.Comp<Integer>(){

            @Override
            public boolean comp(Integer n2, Integer n3) {
                return n2 < n3;
            }
        }), n2);
        this.print("zip", list.zip(new List.Zip<Integer, Integer, String>(){

            @Override
            public String zip(Integer n2, Integer n3) {
                return "" + n2 + ":" + n3;
            }
        }, List.create(9, 8, 7, 6, 5, 4, 3, 2, 1, 0)), n2);
        this.print("replace", List.create(1L, 2L, 3L, 4L, 5L, 6L).replace((Long)4, (Long)99L), n2);
        this.print("replace", List.create(1L, 2L, 3L, 4L, 5L, 6L).replace(3L, (Long)99L), n2);
        this.print("replaceAll", List.create(1L, 2L, 3L, 3L, 2L, 1L).replaceAll(2L, (Long)99L), n2);
        this.out("\n ** Total: " + this.total + "  Failed: " + this.fails + "\n\n");
    }

    void print(String string, Object object, int n2) {
        if (n2 <= 20) {
            this.outln(this.extend(string, 20) + " : " + object);
        }
    }

    String extend(String string, int n2) {
        if (string.length() < n2) {
            return this.extend(" " + string, n2);
        }
        return string;
    }

    void outln(String string) {
        this.out(string + "\n");
    }

    void out(String string) {
        System.out.print(string);
    }

    void test(String string, boolean bl) {
        ++this.total;
        if (!bl) {
            this.out(" !! Test #" + this.total + " Failed \"" + string + "\"\n");
            ++this.fails;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Odd
    extends List.Pred<Integer> {
        Odd() {
        }

        @Override
        public boolean huh(Integer n2) {
            return (n2 & 1) == 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Even
    extends List.Pred<Integer> {
        Even() {
        }

        @Override
        public boolean huh(Integer n2) {
            return (n2 & 1) == 0;
        }
    }
}

