/*
 * Decompiled with CFR 0.152.
 */
package player.playeragent;

import edu.neu.ccs.demeterf.TUCombiner;
import edu.neu.ccs.demeterf.demfgen.lib.List;
import edu.neu.ccs.demeterf.demfgen.lib.Set;
import edu.neu.ccs.demeterf.demfgen.lib.ident;
import edu.neu.ccs.demeterf.stackless.HeapTrav;
import gen.Assignment;
import gen.Derivative;
import gen.FinishedProduct;
import gen.IntermediateProduct;
import gen.Literal;
import gen.Neg;
import gen.Pos;
import gen.Quality;
import gen.RawMaterial;
import gen.RawMaterialInstance;
import gen.Sign;
import gen.Variable;
import hidden.Tools;
import player.GenericPlayer;
import player.PlayerI;
import player.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FinishAgent
implements PlayerI.FinishAgentI {
    static Sign pos = new Pos();
    static Sign neg = new Neg();
    static int NUM_ASSIGNS = 60;

    @Override
    public FinishedProduct finishDerivative(Derivative derivative) {
        Best best = FinishAgent.bestAssign(derivative);
        double d = Tools.payback(derivative, best.quality) - derivative.price.val;
        System.out.print("<i>" + new GenericPlayer().getName() + "</i>: ");
        System.out.println("<span style=\"color:" + (d > 0.0 ? "green\">Making" : "red\">Losing") + "</span> <b>" + Math.abs(d) + "</b><br/>");
        return new FinishedProduct(new IntermediateProduct(best.assign), new Quality(best.quality));
    }

    public static Best bestAssign(Derivative derivative) {
        return FinishAgent.bestAssign(((RawMaterial)derivative.optraw.inner()).instance, NUM_ASSIGNS);
    }

    public static Best bestAssign(RawMaterialInstance rawMaterialInstance, int n) {
        final Set<ident> set = FinishAgent.usedVars(rawMaterialInstance);
        List<Assignment> list = List.buildlist(new List.Build<Assignment>(){

            @Override
            public Assignment build(int n) {
                return new Assignment(FinishAgent.randomAssign(set, Util.random()));
            }
        }, n);
        return FinishAgent.bestAssign(list, rawMaterialInstance);
    }

    private static Best bestAssign(List<Assignment> list, final RawMaterialInstance rawMaterialInstance) {
        return list.fold(new List.Fold<Assignment, Best>(){

            @Override
            public Best fold(Assignment assignment, Best best) {
                double d = Tools.quality(rawMaterialInstance, assignment);
                if (d < best.quality) {
                    return best;
                }
                return new Best(d, assignment);
            }
        }, new Best());
    }

    private static List<Literal> randomAssign(Set<ident> set) {
        return FinishAgent.randomAssign(set, 0.5);
    }

    private static List<Literal> randomAssign(Set<ident> set, final double d) {
        return set.toList().map(new List.Map<ident, Literal>(){

            @Override
            public Literal map(ident ident2) {
                return new Literal(Util.coinFlip(d) ? pos : neg, new Variable(ident2));
            }
        });
    }

    private static Set<ident> usedVars(RawMaterialInstance rawMaterialInstance) {
        return (Set)new HeapTrav(new TUCombiner<Set<ident>>(){

            @Override
            public Set<ident> combine() {
                return Set.create();
            }

            @Override
            public Set<ident> fold(Set<ident> set, Set<ident> set2) {
                return set.union(set2);
            }

            Set<ident> combine(ident ident2) {
                return Set.create(List.create(ident2));
            }
        }).traverse(rawMaterialInstance);
    }

    static class Best {
        double quality;
        Assignment assign;

        Best() {
            this(-1.0, null);
        }

        Best(double d, Assignment assignment) {
            this.quality = d;
            this.assign = assignment;
        }
    }
}

