/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.parallel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeSort {
    static void p(String string) {
        System.out.println(string);
    }

    public static void main(String[] stringArray) {
        L<Integer> l2 = MergeSort.rand(10);
        MergeSort.p("  List: " + l2);
        MergeSort.p(" Split: " + l2.split(l2.length() / 2));
        MergeSort.p(" Front: " + l2.front(l2.length() / 2));
        MergeSort.p("  Back: " + l2.back(l2.length() / 2));
    }

    static L<Integer> make(int ... nArray) {
        return MergeSort.make(nArray, nArray.length - 1);
    }

    static L<Integer> make(int[] nArray, int n2) {
        return n2 < 0 ? new L<Integer>() : MergeSort.make(nArray, n2 - 1).push(nArray[n2]);
    }

    static int randInt() {
        return (int)(Math.random() * 20.0);
    }

    static L<Integer> rand(int n2) {
        return n2 == 0 ? new L<Integer>() : MergeSort.rand(n2 - 1).push(MergeSort.randInt());
    }

    static <D extends Comparable<D>> L<D> merge(L<D> l2, L<D> l3) {
        if (l2.isEmpty()) {
            return l3;
        }
        if (l3.isEmpty()) {
            return l2;
        }
        if (l2.first().compareTo(l3.first()) <= 0) {
            return MergeSort.merge(l2.rest(), l3).push(l2.first());
        }
        return MergeSort.merge(l2, l3.rest()).push(l3.first());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class C<D extends Comparable<D>>
    extends L<D> {
        D f;
        L<D> r;

        C(D d2, L<D> l2) {
            this.f = d2;
            this.r = l2;
        }

        @Override
        boolean isEmpty() {
            return false;
        }

        @Override
        D first() {
            return this.f;
        }

        @Override
        L<D> rest() {
            return this.r;
        }

        @Override
        int length() {
            return 1 + this.r.length();
        }

        @Override
        L<D> reverse(L<D> l2) {
            return this.r.reverse(l2.push(this.f));
        }

        @Override
        L<D> append(L<D> l2) {
            return this.r.append(l2).push(this.f);
        }

        @Override
        L.P<D> split(int n2, L<D> l2) {
            return n2 == 0 ? new L.P<D>(l2.reverse(), this) : this.r.split(n2 - 1, l2.push(this.f));
        }

        @Override
        L<D> front(int n2) {
            return n2 == 0 ? new L() : this.r.front(n2 - 1).push(this.f);
        }

        @Override
        L<D> back(int n2) {
            return n2 == 0 ? this : this.r.back(n2 - 1);
        }

        @Override
        public String toString() {
            return this.f + " " + this.r;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class L<D extends Comparable<D>> {
        L() {
        }

        boolean isEmpty() {
            return true;
        }

        D first() {
            throw new RuntimeException("L.first() Bad");
        }

        L<D> rest() {
            throw new RuntimeException("L.rest() Bad");
        }

        int length() {
            return 0;
        }

        L<D> reverse() {
            return this.reverse(new L<D>());
        }

        L<D> reverse(L<D> l2) {
            return l2;
        }

        L<D> push(D d2) {
            return new C<D>(d2, this);
        }

        L<D> append(L<D> l2) {
            return l2;
        }

        P<D> split(int n2) {
            return this.split(n2, new L<D>());
        }

        P<D> split(int n2, L<D> l2) {
            throw new RuntimeException("L.split() Bad");
        }

        L<D> front(int n2) {
            throw new RuntimeException("L.split() Bad");
        }

        L<D> back(int n2) {
            throw new RuntimeException("L.split() Bad");
        }

        public String toString() {
            return "";
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class P<D extends Comparable<D>> {
            L<D> lt;
            L<D> rt;

            P(L<D> l2, L<D> l3) {
                this.lt = l2;
                this.rt = l3;
            }

            public String toString() {
                return "<" + this.lt + " :: " + this.rt + ">";
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PSorter<D extends Comparable<D>>
    extends Sorter<D> {
        PSorter() {
        }

        @Override
        public L<D> sort(L<D> l2) {
            int n2 = l2.length();
            if (n2 <= 1) {
                return l2;
            }
            L.P<D> p2 = l2.split(n2 / 2);
            Thrd thrd = new Thrd(p2.lt);
            thrd.start();
            L l3 = this.recsort(p2.rt);
            p2 = null;
            thrd.waitFor();
            return MergeSort.merge(thrd.res, l3);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Thrd
        extends Thread {
            L<D> lst;
            L<D> res;
            boolean fin = false;

            Thrd(L<D> l2) {
                this.lst = l2;
                this.res = null;
            }

            @Override
            public void run() {
                this.res = PSorter.this.recsort(this.lst);
                this.done();
            }

            synchronized void done() {
                this.fin = true;
                this.notifyAll();
            }

            synchronized void waitFor() {
                try {
                    while (!this.fin) {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Sorter<D extends Comparable<D>> {
        Sorter() {
        }

        public L<D> sort(L<D> l2) {
            return this.recsort(l2);
        }

        public L<D> recsort(L<D> l2) {
            int n2 = l2.length();
            if (n2 <= 1) {
                return l2;
            }
            L.P<D> p2 = l2.split(n2 / 2);
            return MergeSort.merge(this.recsort(p2.lt), this.recsort(p2.rt));
        }

        public T timesort(L<D> l2) {
            System.gc();
            Thread.yield();
            long l3 = System.currentTimeMillis();
            L<D> l4 = this.sort(this.sort(l2));
            return new T(System.currentTimeMillis() - l3, l4);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class T {
            long mil;
            L<D> lst;

            T(long l2, L<D> l3) {
                this.mil = l2;
                this.lst = l3;
            }

            public String toString() {
                return " MSec: " + this.mil;
            }
        }
    }
}

