/*
 * Decompiled with CFR 0.152.
 */
package admin;

import admin.Administrator;
import admin.Output;
import admin.ProcessWatcher;
import admin.StreamWatcher;
import admin.Util;
import admin.utils.AccountUpdater;
import admin.utils.AdminCmdLineParser;
import admin.utils.AdminDocumentHandler;
import admin.utils.Game;
import admin.utils.RuleChecker;
import admin.utils.StoreUpdater;
import config.AdminConfig;
import edu.neu.ccs.demeterf.demfgen.lib.List;
import gen.Accounts;
import gen.Config;
import gen.Deliver;
import gen.Finish;
import gen.Pair;
import gen.Player;
import gen.PlayerID;
import gen.PlayerTransaction;
import gen.Players;
import gen.Round;
import gen.Store;
import gen.Transaction;
import java.io.File;
import java.io.IOException;
import tournament.Result;
import tournament.TournHTMLOutput;
import tournament.Tournament;
import utils.comparator.LargerBalance;

public class TournAdmin
extends Administrator {
    public TournAdmin(Output output) {
        super(output, "1M");
    }

    public Result runMatch(Player player, Player player2, Game.GameType gameType) {
        PlayerID playerID;
        List<Object> list;
        Config config = AdminDocumentHandler.getConfig();
        Store store = AdminDocumentHandler.getStore();
        Pair pair = new Pair((Object)player.id, (Object)config.Money);
        Pair pair2 = new Pair((Object)player2.id, (Object)config.Money);
        List<Pair> list2 = List.create(new Pair[0]);
        list2 = list2.append(pair);
        list2 = list2.append(pair2);
        Accounts accounts = new Accounts(list2);
        AdminDocumentHandler.commitAccounts(accounts);
        for (int i = 1; i <= 2 + config.Rounds; ++i) {
            if (this.overtime(i)) {
                System.out.println("OVERTIME ROUND: " + (i - config.Rounds));
            } else {
                System.out.println("ROUND: " + i);
            }
            list = List.create(new Object[0]);
            playerID = new Round(i, list);
            if (!this.passTurn(player, config)) {
                return Result.black("White time violation or jar not found.");
            }
            PlayerTransaction playerTransaction = AdminDocumentHandler.getPlayerTrans(player);
            if (this.overtime(i)) {
                playerTransaction.transactions = playerTransaction.transactions.filter(new List.Pred<Transaction>(){

                    @Override
                    public boolean huh(Transaction transaction) {
                        return transaction.ttype instanceof Deliver || transaction.ttype instanceof Finish;
                    }
                });
            }
            if (playerTransaction == null) {
                return Result.black("No white PlayerTrans.");
            }
            Object object = this.overtime(i) ? RuleChecker.overtimeRulesFollowed(playerTransaction, store, accounts, gameType, config) : RuleChecker.rulesFollowed(playerTransaction, store, accounts, gameType, config);
            if (!((Boolean)object.a).booleanValue()) {
                return Result.black((String)object.b);
            }
            playerTransaction = Util.computeQualities(playerTransaction);
            playerTransaction = Util.truncateRMs(playerTransaction, config.MaxRawMaterialLen);
            store = this.updateStore(playerTransaction, store);
            accounts = this.updateAccounts(playerTransaction, accounts);
            if (!this.passTurn(player2, config)) {
                return Result.white("Black time violation or jar not found.");
            }
            object = AdminDocumentHandler.getPlayerTrans(player2);
            if (this.overtime(i)) {
                object.transactions = object.transactions.filter(new List.Pred<Transaction>(){

                    @Override
                    public boolean huh(Transaction transaction) {
                        return transaction.ttype instanceof Deliver || transaction.ttype instanceof Finish;
                    }
                });
            }
            if (object == null) {
                return Result.white("No black PlayerTrans.");
            }
            Pair<Boolean, String> pair3 = this.overtime(i) ? RuleChecker.overtimeRulesFollowed(object, store, accounts, gameType, config) : RuleChecker.rulesFollowed(object, store, accounts, gameType, config);
            if (!((Boolean)pair3.a).booleanValue()) {
                return Result.white((String)pair3.b);
            }
            object = Util.computeQualities(object);
            object = Util.truncateRMs(object, config.MaxRawMaterialLen);
            store = this.updateStore((PlayerTransaction)object, store);
            accounts = this.updateAccounts((PlayerTransaction)object, accounts);
            AdminDocumentHandler.updateHistory((Round)playerID);
        }
        Accounts accounts2 = AdminDocumentHandler.getAccounts();
        list = accounts2.accounts.sort(new LargerBalance());
        playerID = (PlayerID)list.top().a;
        if (playerID.id == player.id.id) {
            return Result.white("Larger balance: " + ((Pair)list.top()).b);
        }
        return Result.black("Larger balance: " + ((Pair)list.top()).b);
    }

    private Store updateStore(PlayerTransaction playerTransaction, Store store) {
        store = StoreUpdater.updateStore(store, playerTransaction);
        AdminDocumentHandler.commitStore(store);
        return store;
    }

    private Accounts updateAccounts(PlayerTransaction playerTransaction, Accounts accounts) {
        accounts = AccountUpdater.updateAccounts(accounts, playerTransaction);
        AdminDocumentHandler.commitAccounts(accounts);
        return accounts;
    }

    private boolean passTurn(Player player, Config config) {
        String string;
        File file = new File("blackboard" + AdminConfig.PLAYERS_PATH);
        System.out.println("Player " + player.id.id + " of team " + player.name + "'s turn.");
        String string2 = "blackboard" + AdminConfig.PLAYERS_PATH + "/" + player.name;
        String string3 = "java -Xss1M -jar " + player.name + ".jar " + player.id.id + " " + player.name;
        String string4 = string2 + ".exe " + player.id.id + " " + player.name;
        File file2 = new File(string2 + ".jar");
        if (file2.exists()) {
            string = string3;
        } else {
            file2 = new File(string2 + ".exe");
            if (file2.exists()) {
                string = string4;
            } else {
                return false;
            }
        }
        Runtime runtime = Runtime.getRuntime();
        long l = 0L;
        long l2 = 0L;
        try {
            l = System.currentTimeMillis();
            Process process = runtime.exec(string, null, file);
            StreamWatcher streamWatcher = new StreamWatcher(process.getInputStream(), Output.htmlOutput());
            StreamWatcher streamWatcher2 = new StreamWatcher(process.getErrorStream(), Output.htmlOutput());
            ProcessWatcher processWatcher = new ProcessWatcher(process);
            Thread thread = new Thread(streamWatcher);
            Thread thread2 = new Thread(streamWatcher2);
            Thread thread3 = new Thread(processWatcher);
            thread.start();
            thread2.start();
            thread3.start();
            processWatcher.waitForTimeLimit(config.Time);
            Thread.sleep(2000L);
            System.out.flush();
            System.err.flush();
            l2 = System.currentTimeMillis();
            streamWatcher.kill();
            streamWatcher2.kill();
            System.out.println("Player " + player.id.id + " of team " + player.name + " finished in " + (l2 - l) + " milliseconds.");
            if (l2 - l > (long)config.Time) {
                process.destroy();
                System.out.println("Player " + player.id.id + " kicked for time violation.");
                return false;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return true;
    }

    public static void main(String[] stringArray) {
        AdminCmdLineParser adminCmdLineParser = new AdminCmdLineParser(stringArray);
        Players players = AdminDocumentHandler.getPlayers();
        Tournament tournament = new Tournament(players.players, adminCmdLineParser.outputFile, adminCmdLineParser.gt);
        TournHTMLOutput tournHTMLOutput = TournHTMLOutput.tournhtmlOutput(adminCmdLineParser.resultsFile);
        tournHTMLOutput.header();
        tournament.runTournament();
        tournHTMLOutput.finishTable(tournament.getResults());
        tournHTMLOutput.footer();
    }
}

