package player.playeragent;

import edu.neu.ccs.demeterf.demfgen.lib.*;
import gen.*;

import org.junit.BeforeClass;
import org.junit.Test;
import static org.junit.Assert.*;

import player.IAmRobot;
import player.playeragent.CreateAgent;

public class CreateAgentTest {
	private static CreateAgent agent;
	private static List<Type> existing;
	
	@BeforeClass
	public static void setUpBeforeClass() {
		agent = new CreateAgent();
		existing = List.<Type>create();
	}
	
	@Test
	public void createTests() {
		// createDerivative produces a pseudorandom relation number, so run the tests 63 times
		// to cover every possible derivative we'll create
		for (int i = 0; i < 63; i++)
			createTest();
	}

	private void createTest() {
		Derivative forSale = agent.createDerivative(new Player(new PlayerID(1), "B"), existing);
		
		// Ensure the type created does not already exist in the "store"
		assertTrue(!existing.contains(forSale.type));
		
		// Add the created type to the "store"
		existing = existing.append(forSale.type);
		
		for (TypeInstance typeInst : forSale.type.instances) {
			int relNum = typeInst.r.v;
			
			// Check for "bad" relation numbers
			assertTrue(relNum > 0);
			assertTrue(relNum < 128);
			assertTrue(relNum % 2 == 0);
		}
		
		assertEquals(IAmRobot.getBreakEven(forSale), forSale.price.val);
	}
}
