package player.playeragent;

import edu.neu.ccs.demeterf.demfgen.lib.*;
import gen.*;

import org.junit.Before;
import org.junit.Test;
import static org.junit.Assert.*;

import player.playeragent.BuyAgent;

public class BuyAgentTest {
	private BuyAgent buyer;
	private Derivative d1, d2, d3, d4;
	
	@Before
	public void setUp() {
		buyer = new BuyAgent();
		
		List<TypeInstance> typeInst = List.<TypeInstance>create(new TypeInstance(new RelationNr(22)));
    	d1 = new Derivative("D1", new PlayerID(0), new Price(.44444443), new Type(typeInst));
    	List<TypeInstance> typeInst2 = List.<TypeInstance>create(new TypeInstance(new RelationNr(22)));
    	d2 = new Derivative("D2", new PlayerID(0), new Price(.44444443), new Type(typeInst2));
    	List<TypeInstance> typeInst3 = List.<TypeInstance>create(new TypeInstance(new RelationNr(22)));
    	d3 = new Derivative("D3", new PlayerID(0), new Price(.2), new Type(typeInst3));
    	List<TypeInstance> typeInst4 = List.<TypeInstance>create(new TypeInstance(new RelationNr(22)));
    	d4 = new Derivative("D4", new PlayerID(0), new Price(.4), new Type(typeInst4));
	}
	
	@Test
	public void buyDerivativesTestSingle() {
    	List<Derivative> forSale = List.<Derivative>create(d1);
    	
    	List<Derivative> bought = buyer.buyDerivatives(forSale, 1.0);
    	assertEquals(1, bought.length());
    	
    	bought = buyer.buyDerivatives(forSale, .43);
    	assertEquals(0, bought.length());
	}
	
	@Test
	public void buyDerivativesTestMultiple() {
    	List<Derivative> forSale = List.<Derivative>create(d1, d2, d3, d4);
    	
    	List<Derivative> bought = buyer.buyDerivatives(forSale, 1.0);
    	assertEquals(2, bought.length());
    	
    	bought = buyer.buyDerivatives(forSale, 10);
    	assertEquals(4, bought.length());
	}
}
