package player;

import static org.junit.Assert.*;
import edu.neu.ccs.demeterf.demfgen.lib.*;
import gen.*;

import org.junit.Test;


public class PlayerTest {
	@Test 
    public void breakEvenR0() {
    	testBreakEven(0, 0);
    }
	@Test 
    public void breakEvenR6() {
    	testBreakEven(6, 0.2962962962962963);
    }
	@Test 
    public void breakEvenR10() {
    	testBreakEven(10, 0.25);
    }
	@Test 
    public void breakEvenR12() {
    	testBreakEven(12, 0.25);
    }
	@Test 
    public void breakEvenR14() {
    	testBreakEven(14, 0.38490017945975047);
    }
	@Test 
    public void breakEvenR18() {
    	testBreakEven(18, 0.2962962962962963);
    }
	@Test 
    public void breakEvenR20() {
    	testBreakEven(20, 0.2962962962962963);
    }
	@Test 
    public void breakEvenR22() {
    	testBreakEven(22, 0.444444444444444);
    }
	@Test 
    public void breakEvenR24() {
    	testBreakEven(24, 0.25);
    }
	@Test 
    public void breakEvenR26() {
    	testBreakEven(26, 0.38490018);
    }
	@Test 
    public void breakEvenR28() {
    	testBreakEven(28, 0.38490018);
    }
	@Test 
    public void breakEvenR60() {
    	testBreakEven(58, 0.5);
    }
	@Test 
    public void breakEvenR114() {
    	testBreakEven(114, 0.5);
    }
	
	@Test 
    public void breakEvenPowersOf2() {
		for (int i = 2; i < 128; i = i*2)
			testBreakEven(i, 0.14814814814814814);
    }
	
	@Test 
    public void breakEvenOdd() {
		for (int i = 1; i <= 127; i = i+2)
			testBreakEven(i, 1);
    }
	
	@Test 
    public void breakEvenAboveR128() {
		for (int i = 128; i <= 255; i++)
			testBreakEven(i, 1);
    }
	
	
	@Test 
    public void bMaxR0() {
		testBMax(0, 0);
    }
	@Test 
    public void bMaxR2() {
		testBMax(2, 0.3333333333333333);
    }
	@Test 
    public void bMaxR4() {
		testBMax(4, 0.3333333333333333);
    }
	@Test 
    public void bMaxR6() {
		testBMax(6, 0.3333333333333333);
    }
	@Test 
    public void bMaxR8() {
		testBMax(8, 0.66666666666666666);
    }
	@Test 
    public void bMaxR10() {
		testBMax(10, 0.5);
    }
	@Test 
    public void bMaxR12() {
		testBMax(12, 0.5);
    }
	@Test 
    public void bMaxR14() {
		testBMax(14, 0.42264973081037427);
    }
	@Test 
    public void bMaxR16() {
		testBMax(16, 0.333333333333333333);
    }
	@Test 
    public void bMaxR18() {
		testBMax(18, 0.333333333333333333);
    }
	@Test 
    public void bMaxR20() {
		testBMax(20, 0.333333333333333333);
    }
	@Test 
    public void bMaxR22() {
		testBMax(22, 0.333333333333333333);
    }
	
	private void testBreakEven(int relationNum, double expected)
	{
		Type type = new Type(List.<TypeInstance>create(new TypeInstance(new RelationNr(relationNum))));
    	Derivative testDeriv = new Derivative("D1", new PlayerID(0), new Price(1), type);
    	
    	double actual = IAmRobot.getBreakEven(testDeriv);

    	assertEquals("Relation " + relationNum, expected, actual, 0.0000001);
	}
	
	private void testBMax(int relationNum, double expected)
	{
		Type type = new Type(List.<TypeInstance>create(new TypeInstance(new RelationNr(relationNum))));
    	Derivative testDeriv = new Derivative("D1", new PlayerID(0), new Price(1), type);
    	
    	double actual = IAmRobot.getBMax(testDeriv);

    	assertEquals("Relation " + relationNum, expected, actual, 0.0000001);
	}
}
