package neg;

import org.aspectj.lang.reflect.*;

/**
 * This guy ensures that no negative number is ever
 * passed to a method in Computation.
 */
public aspect EnsurePositive2 {
  
  pointcut callTargets(double d): 
    call(double neg.Computation.*(double)) && args(d);
    
  double around(double d): 
    if (AspectConfig.ENSURE_POSITIVE) 
    && callTargets(d) {
    if (d < 0) d = -d;
    return proceed(d);
  }
}