class DisplayVisitor extends Visitor {
	private int indent = 0;
	
  public void before(A host) {
    System.out.print(": A  (");
    indent++;
  }
  public void after(A host) {
    System.out.print(" )");
    indent--;
  }
  public void before_x(A source, X dest) {
    System.out.println();
    for (int i = 0; i < indent; i++) System.out.print("\t");
    System.out.print("<x> ");
  }
  public void before_c(A source, C dest) {
    System.out.println();    
    for (int i = 0; i < indent; i++) System.out.print("\t");
    System.out.print("<c1> ");
  }
  public void before_d(A source, D dest) {
    System.out.println();    
    for (int i = 0; i < indent; i++) System.out.print("\t");
    System.out.print("<d> ");
  }
  public void before(C host) {
    System.out.print(": C  (");
    indent++;
  }
  public void after(C host) {
    System.out.print(" )");
    indent--;
  }
  public void before(D host) {
    System.out.print(": D  (");
    indent++;
  }
  public void after(D host) {
    System.out.print(" )");
    indent--;
  }
  public void before(E host) {
    System.out.print(": E  (");
    indent++;
  }
  public void after(E host) {
    System.out.print(" )");
    indent--;
  }
  public void before(X host) {
    System.out.print(": X  (");
    indent++;
  }
  public void after(X host) {
    System.out.print(" )");
    indent--;
  }
  public void before(F host) {
    System.out.print(": F  (");
    indent++;
  }
  public void after(F host) {
    System.out.print(" )");
    indent--;
  }
  public void before_g1(F source, G dest) {
    System.out.println();
    for (int i = 0; i < indent; i++) System.out.print("\t");
    System.out.print("<g1> ");
  }
  public void before_h1(F source, H dest) {
    System.out.println();
    for (int i = 0; i < indent; i++) System.out.print("\t");
    System.out.print("<h1> ");
  }
  public void before_a1(F source, A dest) {
    System.out.println();
    for (int i = 0; i < indent; i++) System.out.print("\t");
    System.out.print("<a1> ");
  }
  public void before(G host) {
    System.out.print(": G  (");
    indent++;
  }
  public void after(G host) {
    System.out.print(" )");
    indent--;
  }
  public void before(H host) {
    System.out.print(": H  (");
    indent++;
  }
  public void after(H host) {
    System.out.print(" )");
    indent--;
  }
  
}
