class A {
  private B b1 = null;
  private C c1 = null;
  private D d = null;
  
  public A(B b1, C c1) {
  	this.b1 = b1;
  	this.c1 = c1;
  }

  public A(B b1, C c1, D d) {
  	this.b1 = b1;
  	this.c1 = c1;
  	this.d = d;
  }

  public void set_b1(B b1) {
  	this.b1 = b1;
  }
  
  public void set_c1(C c1) {
  	this.c1 = c1;
  }
  
  public void set_d(D d) {
  	this.d = d;
  }
  
  public B get_b1() {
  	return b1;
  }
  
  public C get_c1() {
  	return c1;
  }
  
  public D get_d() {
  	return d;
  }
  
  public void print() {
  	traverse(new PrintVisitor(true));
  }
  
  public void display() {
  	traverse(new DisplayVisitor());
  }
  
  public int countG() {
  	CountVisitor cv = new CountVisitor();
  	traverse(cv);
  	return cv.getReturnValue();
  }
  
  protected void traverse(Visitor v) {
  	v.before(this);
  	
  	v.before_b1(this, b1);
  	b1.traverse(v);
  	v.after_b1(this, b1);
  	
  	v.before_c1(this, c1);
  	c1.traverse(v);
  	v.after_c1(this, c1);
  	
  	if (null != d) {
  	  v.before_d(this, d);
  	  d.traverse(v);
  	  v.after_d(this, d);
  	}
  	
  	v.after(this);
  }
  
}
