package edu.neu.ccs.satsolver;

/**
 * OutputI instances are returned by the outsourcing team code back to the csu
 * team code as a result of computations.
 */
public interface OutputI {
	/**
	 * Returns the maximum bias representing the bent coin for the input pairs.
	 * <p>
	 * Return value will be 0.0 <= getMaxBias() <= 1.0
	 * 
	 * @return the maximum bias
	 */
	public double getMaxBias();

	/**
	 * Returns the polynomial generated by the PairI values.
	 *  
	 * @return Polynomial
	 * 
	 * @see edu.neu.ccs.satsolver.PolynomialI
	 */
	public PolynomialI getPolynomial();
}
