/**
 * Code by Ahmed Abdel Mohsen
 * Original version at https://www.ccs.neu.edu/course/csg260/ssl/RelationReduction/
 */
package edu.neu.ccs.satsolver.util;

import junit.framework.TestCase;

public class RelationTest extends TestCase {

	public void testOnes() {
		for (int i = 0; i < 256; i++) {
			int q0 = Relation.q(i, 0);
			int q1 = Relation.q(i, 1);
			int q2 = Relation.q(i, 2);
			int q3 = Relation.q(i, 3);
			int t = q0 + q1 + q2 + q3;
			int o = Relation.ones(i);
			System.out.println("ones in " + i + "=  " + q0 + " " + q1 + " " + q2 + " " + q3 + "   "
					+ t + "  " + o + "     " + (t - o));
		}
	}

	public void testReduce() {
		System.out.println("Rel:\tX0=0\tX0=1\tX1=0\tX1=1\tX2=0\tX2=1");
		for (int i = 0; i < 256; i++) {
			System.out.print("" + i + ":");
			for (int k = 0; k < 3; k++) {
				for (int j = 0; j <= 1; j++) {
					int newR = Relation.reduce(i, k, j);
					System.out.print("\t" + newR);
					assertTrue((newR <= 255) && (newR >= 0));
				}
			}
			System.out.println("");
		}

	}

}
