/**
 * Code by Daniel Rinehart <danielr@neophi.com>
 * Created for CSG260 Fall 2006 with Karl Lieberherr
 */
package edu.neu.ccs.satsolver.util;

import junit.framework.TestCase;

public class AppSATTest extends TestCase {
	public void testAppSat() {
		Polynomial polynomial = AppSAT.appSAT(0);
		assertEquals(0, polynomial.degree());
		assertEquals(0, polynomial.getCoefficient(0), Polynomial.DELTA);

		// x or y or z
		polynomial = AppSAT.appSAT(254);
		assertEquals(3, polynomial.degree());
		assertEquals(1.0, polynomial.getCoefficient(3), Polynomial.DELTA);
		assertEquals(-3.0, polynomial.getCoefficient(2), Polynomial.DELTA);
		assertEquals(3.0, polynomial.getCoefficient(1), Polynomial.DELTA);
		assertEquals(0.0, polynomial.getCoefficient(0), Polynomial.DELTA);

		// !x
		polynomial = AppSAT.appSAT(85);
		assertEquals(1, polynomial.degree());
		assertEquals(0.0, polynomial.getCoefficient(3), Polynomial.DELTA);
		assertEquals(0.0, polynomial.getCoefficient(2), Polynomial.DELTA);
		assertEquals(-1.0, polynomial.getCoefficient(1), Polynomial.DELTA);
		assertEquals(1.0, polynomial.getCoefficient(0), Polynomial.DELTA);
	}
}
