package xAspectsEditor.editors;

import org.eclipse.ui.editors.text.TextEditor;

import xAspectsEditor.editors.xAspConfiguration;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.custom.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.*;
import java.lang.StringBuffer;
import org.eclipse.swt.graphics.Color;

public class xAspEditor extends TextEditor{
	public StringBuffer errorBuffer;
	public xAspDocumentProvider provider;
	public edu.neu.ccs.demeter.dj.ClassGraph cgDJ;
	private StyledText outputWindow;
	private Composite parent;
	public xAspEditor() {
		super();
		setSourceViewerConfiguration(new xAspConfiguration());
		this.provider = new xAspDocumentProvider();
		setDocumentProvider(provider);
		this.setErrorBuffer();
		cgDJ = new edu.neu.ccs.demeter.dj.ClassGraph(true,false);
		defineClassGraph();
	}
	public void createPartControl(Composite comp) {
		this.parent = comp;
		super.createPartControl(parent);
		
		outputWindow = new StyledText(parent, 1);
		super.createPartControl(outputWindow);
		
		FillLayout layout = (FillLayout) parent.getLayout();
		layout.type = SWT.VERTICAL;		
		parent.setLayout(layout);
	}
	
	public xAspDocumentProvider getProvider(){
		return this.provider;
	}
	public edu.neu.ccs.demeter.dj.ClassGraph getClassGraph(){
		return this.cgDJ;
	}
	
	public void setView(String text){
		outputWindow.setText(text);
	}
	public void setStyle(int s, int f, Color fg, Color bg){
		outputWindow.setStyleRange(new StyleRange(s, f, fg, bg));
	}
	public void addError(String err){
		this.errorBuffer.append(err);
	}
	public void setErrorBuffer(){
		this.errorBuffer = new StringBuffer();
	}
	public boolean exceptionThrown(){
		if(this.errorBuffer.length() > 0){
			return true;
		}
		return false;
	}
	public String getErrorMsg(){
		return this.errorBuffer.toString();
	}
	public void defineClassGraph(){
		Class[] classes ={
				xAspectsEditor.cd.__Subtraversal.class,
		    	xAspectsEditor.cd.Absolute.class,
		    	xAspectsEditor.cd.ClassDict.class,
		    	xAspectsEditor.cd.ClassName.class,
		    	xAspectsEditor.cd.CompactXPath.class,
		    	xAspectsEditor.cd.ComplexXPathRef.class,
		    	xAspectsEditor.cd.ContextNode.class,
		    	xAspectsEditor.cd.CopyVisitor.class,
		    	xAspectsEditor.cd.CXPathExp.class,
		    	xAspectsEditor.cd.DisplayVisitor.class,
		    	xAspectsEditor.cd.EqualVisitor.class,
		    	xAspectsEditor.cd.Except.class,
		    	edu.neu.ccs.demeter.Ident.class,
		    	xAspectsEditor.cd.Intersect.class,
		    	xAspectsEditor.cd.JavaCharStream.class,
		    	xAspectsEditor.cd.Main.class,
		    	xAspectsEditor.cd.Nonempty_TraversalRef_NList.class,
		    	xAspectsEditor.cd.Op.class,
		    	xAspectsEditor.cd.ParseException.class,
		    	xAspectsEditor.cd.Parser.class,
		    	xAspectsEditor.cd.ParserConstants.class,
		    	xAspectsEditor.cd.ParserTokenManager.class,
		    	xAspectsEditor.cd.PathDir.class,
		    	xAspectsEditor.cd.PrintVisitor.class,
		    	xAspectsEditor.cd.Relative.class,
		    	xAspectsEditor.cd.SimpleXPathRef.class,
		    	xAspectsEditor.cd.Strategy.class,
		    	xAspectsEditor.cd.StratExpression.class,
		    	xAspectsEditor.cd.SubgraphVisitor.class,
		    	edu.neu.ccs.demeter.Text.class,
		    	xAspectsEditor.cd.Token.class,
		    	xAspectsEditor.cd.TokenMgrError.class,
		    	xAspectsEditor.cd.TraceVisitor.class,
		    	xAspectsEditor.cd.Traversal.class,
		    	xAspectsEditor.cd.TraversalDict.class,
		    	xAspectsEditor.cd.TraversalName.class,
		    	xAspectsEditor.cd.TraversalRef_NList.class,
		    	xAspectsEditor.cd.TraversalRef.class,
		    	xAspectsEditor.cd.Union.class,
		    	xAspectsEditor.cd.UniversalVisitor.class,
		    	xAspectsEditor.cd.Variable.class,
		    	xAspectsEditor.cd.VerboseXPath.class,
		    	xAspectsEditor.cd.XAspect.class,
		    	xAspectsEditor.cd.XPath.class,
		    	xAspectsEditor.cd.XPathDef.class,
		    	xAspectsEditor.cd.XPathExp.class,
		    	xAspectsEditor.cd.XPathExpression.class,
		    	xAspectsEditor.cd.XPathRef.class,
		    };
		    for(int i=0; i<classes.length; ++i){
		    	  this.cgDJ.addClass(classes[i]);
		    }
	}
}