/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.widgets;

import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.forms.widgets.ILayoutExtension;
import org.eclipse.ui.forms.widgets.LayoutComposite;
import org.eclipse.ui.internal.forms.widgets.FormUtil;
import org.eclipse.ui.internal.forms.widgets.FormsResources;

public class Form
extends Composite {
    private int TITLE_HMARGIN = 10;
    private int TITLE_VMARGIN = 5;
    private int TITLE_GAP = 5;
    private Image backgroundImage;
    private boolean backgroundImageTiled;
    private String text;
    private Composite body;
    private ToolBarManager toolBarManager;

    public Form(Composite parent, int style) {
        super(parent, 0x40000 | style);
        this.addListener(9, new Listener(){

            public void handleEvent(Event e) {
                Form.this.onPaint(e.gc);
            }
        });
        super.setLayout((Layout)new FormLayout());
        this.body = new LayoutComposite(this, 0);
        this.body.setMenu(parent.getMenu());
    }

    public void setMenu(Menu menu) {
        super.setMenu(menu);
        this.body.setMenu(menu);
    }

    public final Point computeSize(int wHint, int hHint, boolean changed) {
        return ((FormLayout)this.getLayout()).computeSize(this, wHint, hHint, changed);
    }

    public final void setLayout(Layout layout) {
    }

    public String getText() {
        return this.text;
    }

    public void setForeground(Color fg) {
        super.setForeground(fg);
        this.body.setForeground(fg);
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        this.body.setBackground(bg);
        if (this.toolBarManager != null) {
            this.toolBarManager.getControl().setBackground(bg);
        }
    }

    public void setText(String text) {
        this.text = text;
        this.layout();
        this.redraw();
    }

    public Image getBackgroundImage() {
        return this.backgroundImage;
    }

    public void setBackgroundImage(Image backgroundImage) {
        this.backgroundImage = backgroundImage;
        this.redraw();
    }

    public IToolBarManager getToolBarManager() {
        if (this.toolBarManager == null) {
            this.toolBarManager = new ToolBarManager(0x800000);
            ToolBar toolbar = this.toolBarManager.createControl((Composite)this);
            toolbar.setBackground(this.getBackground());
            toolbar.setForeground(this.getForeground());
            toolbar.setCursor(FormsResources.getHandCursor());
            this.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (Form.this.toolBarManager != null) {
                        Form.this.toolBarManager.dispose();
                        Form.this.toolBarManager = null;
                    }
                }
            });
        }
        return this.toolBarManager;
    }

    public void updateToolBar() {
        if (this.toolBarManager != null) {
            this.toolBarManager.update(false);
        }
    }

    public Composite getBody() {
        return this.body;
    }

    private void onPaint(GC gc) {
        if (this.text == null) {
            return;
        }
        Rectangle carea = this.getClientArea();
        gc.setFont(this.getFont());
        Point textSize = FormUtil.computeWrapSize(gc, this.text, carea.width - this.TITLE_HMARGIN - this.TITLE_HMARGIN);
        int theight = this.TITLE_HMARGIN + textSize.y + this.TITLE_HMARGIN + this.TITLE_GAP;
        Image buffer = new Image((Device)this.getDisplay(), carea.width, theight);
        GC bufferGC = new GC((Drawable)buffer, gc.getStyle());
        bufferGC.setBackground(this.getBackground());
        bufferGC.setForeground(this.getForeground());
        bufferGC.setFont(this.getFont());
        Rectangle tbounds = new Rectangle(this.TITLE_HMARGIN, this.TITLE_VMARGIN, carea.width - this.TITLE_HMARGIN - this.TITLE_HMARGIN, textSize.y);
        bufferGC.fillRectangle(0, 0, carea.width, theight);
        if (this.backgroundImage != null) {
            this.drawBackgroundImage(bufferGC, carea.width, this.TITLE_VMARGIN + textSize.y + this.TITLE_VMARGIN);
        }
        FormUtil.paintWrapText(bufferGC, this.text, tbounds);
        gc.drawImage(buffer, 0, 0);
        bufferGC.dispose();
        buffer.dispose();
    }

    private void drawBackgroundImage(GC gc, int width, int height) {
        if (this.backgroundImageTiled) {
            Rectangle ibounds = this.backgroundImage.getBounds();
            int x = 0;
            int y = 0;
            while (true) {
                gc.drawImage(this.backgroundImage, x, y);
                if ((x += ibounds.width) <= width) continue;
                x = 0;
                if ((y += ibounds.height) > height) break;
            }
        } else {
            gc.drawImage(this.backgroundImage, 0, 0);
        }
    }

    public boolean isBackgroundImageTiled() {
        return this.backgroundImageTiled;
    }

    public void setBackgroundImageTiled(boolean backgroundImageTiled) {
        this.backgroundImageTiled = backgroundImageTiled;
        if (this.isVisible()) {
            this.redraw();
        }
    }

    private class FormLayout
    extends Layout
    implements ILayoutExtension {
        FormLayout() {
        }

        public int computeMinimumWidth(Composite composite, boolean flushCache) {
            return this.computeSize((Composite)composite, (int)5, (int)-1, (boolean)flushCache).x;
        }

        public int computeMaximumWidth(Composite composite, boolean flushCache) {
            return this.computeSize((Composite)composite, (int)-1, (int)-1, (boolean)flushCache).x;
        }

        public Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            int ihHint;
            ToolBar toolBar;
            int width = 0;
            int height = 0;
            if (Form.this.text != null) {
                GC gc = new GC((Drawable)composite);
                gc.setFont(Form.this.getFont());
                if (wHint != -1) {
                    Point wsize = FormUtil.computeWrapSize(gc, Form.this.text, wHint);
                    width = wsize.x;
                    height = wsize.y;
                } else {
                    Point extent = gc.textExtent(Form.this.text);
                    width = extent.x;
                    height = extent.y;
                }
                gc.dispose();
            }
            if (Form.this.toolBarManager != null && (toolBar = Form.this.toolBarManager.getControl()) != null) {
                Point tbsize = toolBar.computeSize(-1, -1);
                if (width != 0) {
                    width += Form.this.TITLE_GAP;
                }
                width += tbsize.x;
                height = Math.max(height, tbsize.y);
            }
            if (height != 0) {
                height += Form.this.TITLE_VMARGIN * 2;
            }
            if (width != 0) {
                width += Form.this.TITLE_HMARGIN * 2;
            }
            if ((ihHint = hHint) > 0 && ihHint != -1) {
                ihHint -= height;
            }
            Point bsize = Form.this.body.computeSize(FormUtil.getWidthHint(wHint, (Control)Form.this.body), FormUtil.getHeightHint(ihHint, (Control)Form.this.body), flushCache);
            width = Math.max(bsize.x, width);
            return new Point(width, height += bsize.y);
        }

        protected void layout(Composite composite, boolean flushCache) {
            ToolBar toolBar;
            Rectangle carea = composite.getClientArea();
            int height = 0;
            Point tbsize = null;
            int twidth = carea.width - Form.this.TITLE_HMARGIN * 2;
            if (Form.this.toolBarManager != null && (toolBar = Form.this.toolBarManager.getControl()) != null) {
                tbsize = toolBar.computeSize(-1, -1);
                toolBar.setBounds(carea.width - 1 - Form.this.TITLE_HMARGIN - tbsize.x, Form.this.TITLE_VMARGIN, tbsize.x, tbsize.y);
                height = tbsize.y;
            }
            if (tbsize != null) {
                twidth -= tbsize.x - Form.this.TITLE_GAP;
            }
            if (Form.this.text != null) {
                GC gc = new GC((Drawable)composite);
                gc.setFont(Form.this.getFont());
                height = FormUtil.computeWrapSize((GC)gc, (String)((Form)Form.this).text, (int)twidth).y;
                gc.dispose();
                if (tbsize != null) {
                    height = Math.max(tbsize.y, height);
                }
            }
            if (height > 0) {
                height += Form.this.TITLE_VMARGIN * 2;
            }
            Form.this.body.setBounds(0, height, carea.width, carea.height - height);
        }
    }
}

