/*
 * Decompiled with CFR 0.152.
 */
package jseifried.xaspecteditor.checker;

import jseifried.xaspecteditor.XEditor;
import jseifried.xaspecteditor.dj.XAspectLanguage;
import jseifried.xaspecteditor.view.XView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class XAction
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public void run(IAction action) {
        IWorkbenchPage[] pages = this.window.getPages();
        if (pages[0].getEditors().length == 0) {
            this.showError(1);
            return;
        }
        XView xview = (XView)pages[0].findView("jseifried.xaspecteditor.xview");
        if (xview == null) {
            this.showError(0);
            return;
        }
        Class<?> activeclass = pages[0].getActiveEditor().getClass();
        if (activeclass != ((Object)((Object)new XEditor())).getClass()) {
            this.showError(1);
            return;
        }
        XEditor xeditor = (XEditor)pages[0].getActiveEditor();
        pages[0].saveAllEditors(false);
        IDocument doc = xeditor.getDocumentProvider().getDocument((Object)xeditor.getEditorInput());
        String errors = this.process(doc);
        int red = 0;
        int green = 0;
        int blue = 0;
        if (errors.length() != 0) {
            red = 200;
        } else {
            errors = "Aspect structure parsed successfully.\n\nSelector tracing activated...";
            xeditor.activateTrace();
            blue = 200;
        }
        xview.refresh(errors, red, green, blue);
        xeditor.setXView(xview);
    }

    String process(IDocument doc) {
        try {
            return XAspectLanguage.validate(doc.get());
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.window.getShell(), (String)"XAspect Parse Error!", (String)e.getMessage());
            return null;
        }
    }

    void showError(int errorNum) {
        switch (errorNum) {
            case 0: {
                MessageDialog.openError((Shell)this.window.getShell(), (String)"No XView Availible!", (String)"In order to use this feature an XView window must be open.");
                break;
            }
            case 1: {
                MessageDialog.openError((Shell)this.window.getShell(), (String)"No XEditor Availible!", (String)"In order to use this feature an XEditor must be open and have focus.");
            }
        }
    }
}

