package jseifried.xaspecteditor.dj;
import java.util.Vector;
import edu.neu.ccs.demeter.aplib.TraversalGraph;
import edu.neu.ccs.demeter.aplib.cd.ClassGraph;
import edu.neu.ccs.demeter.aplib.sg.Strategy;
public class XAspectLanguage {
  protected AspectLanguage_List aspectlanguage_list;
  public AspectLanguage_List get_aspectlanguage_list() { return aspectlanguage_list; }
  public void set_aspectlanguage_list(AspectLanguage_List new_aspectlanguage_list) { aspectlanguage_list = new_aspectlanguage_list; }
  public XAspectLanguage() { super(); }
  public XAspectLanguage(AspectLanguage_List aspectlanguage_list) {
    super();
    set_aspectlanguage_list(aspectlanguage_list);
  }
  public static XAspectLanguage parse(java.io.Reader in) throws ParseException { return new Parser(in)._XAspectLanguage(); }
  public static XAspectLanguage parse(java.io.InputStream in) throws ParseException { return new Parser(in)._XAspectLanguage(); }
  public static XAspectLanguage parse(String s) {
    try { return parse(new java.io.StringReader(s)); }
    catch (ParseException e) {
      throw new RuntimeException(e.toString());
    }
  }

   /**
    * Test aspect structure for errors
    *
    * @param string text representing the aspect structure
    * @return string containing any error messages generated
    */
   static public String validate(String string) throws Exception {
    try {
     XAspectLanguage xal = XAspectLanguage.parse(string);
     CDVisitor cdvisitor = new CDVisitor(xal, new Vector(), new Vector(), "");
     xal.universal_trv0(cdvisitor);
     SelVisitor selvisitor = new SelVisitor(
       cdvisitor.get_names(), cdvisitor.get_cgs(), ""); 
     xal.universal_trv0(selvisitor);
     return cdvisitor.get_errors() + selvisitor.get_errors();
    } 

    catch (Exception e) 
    {
     String error = e.getMessage();
     if(e.getClass()==(new java.lang.ArrayIndexOutOfBoundsException()).getClass()) {
      error = "Unknown parse error.\n Check that referenced aspects are valid...\n";
     }
     return "ASPECT STRUCTURE PARSER ERROR: " + error + 
       "\n - ASPECT STRUCTURE NOT PROCESSED -"; 
    }
   }

   /**
    * Search aspect structure for Class Dictionary with the given name
    *
    * @param string text representing the aspect structure
    *        cdname the name of the class dictionary
    * 
    * @return text representing the Class Dictionary structure
    */
   static private ClassGraph getCG(String string, String cdname) {
    try {
     XAspectLanguage xal = XAspectLanguage.parse(string);
     CDVisitor cdvisitor = new CDVisitor(xal, new Vector(), new Vector(), "");
     xal.universal_trv0(cdvisitor);
     return (ClassGraph)cdvisitor.get_cgs().elementAt(cdvisitor.get_names().indexOf(cdname));
    } catch (Exception e) {System.out.println(e.getMessage()); return null;}    
   }

   /**
    * Gather list of Nodes for the given Strategy over given ClassGraph
    *
    * @param string text representing a Strategy
    *        cg the ClassGraph for the Strategy
    * 
    * @return Vector containing textual representations of all nodes touched by
    *         the given Strategy
    */
   static private Vector getNodes(String string, ClassGraph cg) {
    Strategy strategy = Strategy.fromString(string);
    try {
     Vector nodes = new Vector(new TraversalGraph(strategy.toSimpleStrategy(), cg).getNodeSets());
     for (int ctr= 0; ctr < nodes.size(); ctr++) {
      string = nodes.elementAt(ctr).toString();
      string = string.substring(0,string.indexOf(":"));
      nodes.setElementAt(string, ctr);
     }
    return nodes;
    } catch (Exception e) {System.out.println(e.getMessage()); return null;}
   }

   /**
    * Retrieve ClassGraph and set of Nodes for given data
    *
    * @param string text representing the aspect structure
    *        cdname the name of the class dictionary
    *        string text representing a Strategy
    * 
    * @return Vector containing textual representations the ClassGraph and
    *                all nodes touched by the given Strategy
    */
   static public Vector traceStrategy(String string, String cdname, 
     String strategy) {
    ClassGraph cg = getCG(string, cdname);
    Vector nodes = getNodes(strategy, cg);
    Vector returnVal = new Vector();
    returnVal.add(cg.toString());
    returnVal.add(nodes);
    return returnVal;
   }
 
  void universal_trv0_bef(UniversalVisitor _v_) {
    ((UniversalVisitor) _v_).before(this);
  }

  void universal_trv0_aft(UniversalVisitor _v_) {
    ((UniversalVisitor) _v_).after(this);
  }

  void universal_trv0(UniversalVisitor _v_) {
    universal_trv0_bef(_v_);
    ((UniversalVisitor) _v_).before_aspectlanguage_list(this, aspectlanguage_list);
    aspectlanguage_list.universal_trv0(_v_);
    ((UniversalVisitor) _v_).after_aspectlanguage_list(this, aspectlanguage_list);
    universal_trv0_aft(_v_);
  }

}
