package aspectEditor.aspectEditorUtils;
import java.util.jar.JarFile;
import java.util.*;
import java.io.*;
import edu.neu.ccs.demeter.aplib.*;
import edu.neu.ccs.demeter.*;
class SGEdge implements Cloneable {
  protected SourceMarker sourcemarker;
  public SourceMarker get_sourcemarker() { return sourcemarker; }
  public void set_sourcemarker(SourceMarker new_sourcemarker) { sourcemarker = new_sourcemarker; }
  protected GlobSpec source;
  public GlobSpec get_source() { return source; }
  public void set_source(GlobSpec new_source) { source = new_source; }
  protected TargetMarker targetmarker;
  public TargetMarker get_targetmarker() { return targetmarker; }
  public void set_targetmarker(TargetMarker new_targetmarker) { targetmarker = new_targetmarker; }
  protected GlobSpec target;
  public GlobSpec get_target() { return target; }
  public void set_target(GlobSpec new_target) { target = new_target; }
  protected NegativeConstraint constraint;
  public NegativeConstraint get_constraint() { return constraint; }
  public void set_constraint(NegativeConstraint new_constraint) { constraint = new_constraint; }
  public SGEdge() { super(); }
  public SGEdge(SourceMarker sourcemarker, GlobSpec source, TargetMarker targetmarker, GlobSpec target, NegativeConstraint constraint) {
    super();
    set_sourcemarker(sourcemarker);
    set_source(source);
    set_targetmarker(targetmarker);
    set_target(target);
    set_constraint(constraint);
  }
  public static SGEdge parse(java.io.Reader in) throws ParseException { return new Parser(in)._SGEdge(); }
  public static SGEdge parse(java.io.InputStream in) throws ParseException { return new Parser(in)._SGEdge(); }
  public static SGEdge parse(String s) {
    try { return parse(new java.io.StringReader(s)); }
    catch (ParseException e) {
      throw new RuntimeException(e.toString());
    }
  }
  boolean meetsConstraint(Object w, NameMapI N) {
    /*
    Vi = { ui, vi } U { wi | B(ei)(w) = TRUE }
    */
    GlobSpec a = this.get_source();
    GlobSpec b = this.get_target();
    return a.match(w, N) || b.match(w, N) || checkConstraint_Node(w, N);
  }
  boolean meetsConstraint(EdgeI e, NameMapI N) {
    /*
    Ei = { wi -l-> yi | B(ei)(w -l-> y) = TRUE, and
			(B(ei)(w) = TRUE or w = u), and
			(B(ei)(y) = TRUE or y = v) }
    */
    Object w = e.getSource();
    Object y = e.getTarget();
    GlobSpec a = this.get_source();
    GlobSpec b = this.get_target();
    return checkConstraint_Edge(e, N)
	&& (a.match(w, N) || checkConstraint_Node(w, N))
	&& (b.match(y, N) || checkConstraint_Node(y, N));
  }
  boolean checkConstraint_Node(Object v, NameMapI N) {
    __V_SGEdge_checkConstraint_Node v0 = new __V_SGEdge_checkConstraint_Node();
    v0.set_v(v);
    v0.set_N(N);
    v0.start();
    __trav_checkConstraint_Node(v0);
    v0.finish();
    return v0.get_return_val();
  }
  boolean checkConstraint_Edge(EdgeI e, NameMapI N) {
    __V_SGEdge_checkConstraint_Edge v0 = new __V_SGEdge_checkConstraint_Edge();
    v0.set_e(e);
    v0.set_N(N);
    v0.start();
    __trav_checkConstraint_Edge(v0);
    v0.finish();
    return v0.get_return_val();
  }
  boolean isSource() { return sourcemarker != null; }
  boolean isTarget() { return targetmarker != null; }
  public String toString() {
    StringWriter w = new StringWriter();
    PrintWriter pw = new PrintWriter(w);
    universal_trv0(new PrintVisitor(pw));
    pw.flush();
    return w.toString();
  }
  public Object clone() {
    try {
      return super.clone();
    } catch (CloneNotSupportedException e) {
      throw new RuntimeException(e);
    }
  }
  void universal_trv0_bef(UniversalVisitor _v_) {
    ((UniversalVisitor) _v_).before(this);
  }

  void universal_trv0_aft(UniversalVisitor _v_) {
    ((UniversalVisitor) _v_).after(this);
  }

  void universal_trv0(UniversalVisitor _v_) {
    universal_trv0_bef(_v_);
    if (sourcemarker != null) {
      ((UniversalVisitor) _v_).before_sourcemarker(this, sourcemarker);
      sourcemarker.universal_trv0(_v_);
      ((UniversalVisitor) _v_).after_sourcemarker(this, sourcemarker);
    }
    ((UniversalVisitor) _v_).before_source(this, source);
    source.universal_trv0(_v_);
    ((UniversalVisitor) _v_).after_source(this, source);
    if (targetmarker != null) {
      ((UniversalVisitor) _v_).before_targetmarker(this, targetmarker);
      targetmarker.universal_trv0(_v_);
      ((UniversalVisitor) _v_).after_targetmarker(this, targetmarker);
    }
    ((UniversalVisitor) _v_).before_target(this, target);
    target.universal_trv0(_v_);
    ((UniversalVisitor) _v_).after_target(this, target);
    if (constraint != null) {
      ((UniversalVisitor) _v_).before_constraint(this, constraint);
      constraint.universal_trv0(_v_);
      ((UniversalVisitor) _v_).after_constraint(this, constraint);
    }
    universal_trv0_aft(_v_);
  }

  public void __trav_checkConstraint_Node(__V_SGEdge_checkConstraint_Node __v0) {
    java.util.BitSet startSet = new java.util.BitSet();
    startSet.set(0);
    __trav_checkConstraint_Node_SGEdge_trv(startSet, __v0);
  }

  void __trav_checkConstraint_Node_SGEdge_trv_bef(__V_SGEdge_checkConstraint_Node __v0) {  }

  void __trav_checkConstraint_Node_SGEdge_trv_aft(__V_SGEdge_checkConstraint_Node __v0) {  }

  void __trav_checkConstraint_Node_SGEdge_trv(java.util.BitSet nodes, __V_SGEdge_checkConstraint_Node __v0) {
    __trav_checkConstraint_Node_SGEdge_trv_bef(__v0);
    if (constraint != null) {
      { java.util.BitSet newnodes = new java.util.BitSet();
        newnodes.set(0);
        newnodes.and(nodes);
        if (!newnodes.equals(new java.util.BitSet())) {
          constraint.__trav_checkConstraint_Node_SGEdge_trv(newnodes, __v0);
        }
      }
    }
    __trav_checkConstraint_Node_SGEdge_trv_aft(__v0);
  }

  public void __trav_checkConstraint_Edge(__V_SGEdge_checkConstraint_Edge __v0) {
    java.util.BitSet startSet = new java.util.BitSet();
    startSet.set(0);
    __trav_checkConstraint_Edge_SGEdge_trv(startSet, __v0);
  }

  void __trav_checkConstraint_Edge_SGEdge_trv_bef(__V_SGEdge_checkConstraint_Edge __v0) {  }

  void __trav_checkConstraint_Edge_SGEdge_trv_aft(__V_SGEdge_checkConstraint_Edge __v0) {  }

  void __trav_checkConstraint_Edge_SGEdge_trv(java.util.BitSet nodes, __V_SGEdge_checkConstraint_Edge __v0) {
    __trav_checkConstraint_Edge_SGEdge_trv_bef(__v0);
    if (constraint != null) {
      { java.util.BitSet newnodes = new java.util.BitSet();
        newnodes.set(0);
        newnodes.and(nodes);
        if (!newnodes.equals(new java.util.BitSet())) {
          constraint.__trav_checkConstraint_Edge_SGEdge_trv(newnodes, __v0);
        }
      }
    }
    __trav_checkConstraint_Edge_SGEdge_trv_aft(__v0);
  }

}
