/*
 * Decompiled with CFR 0.152.
 */
package aspectEditor.aspectEditorUtils;

import aspectEditor.aspectEditorUtils.Main;
import aspectEditor.aspectEditorUtils.ParseException;
import aspectEditor.aspectEditorUtils.Parser;
import aspectEditor.aspectEditorUtils.SelectorL;
import aspectEditor.aspectEditorUtils.Simple;
import aspectEditor.aspectEditorUtils.StrategyDef;
import aspectEditor.aspectEditorUtils.StrategyName;
import aspectEditor.aspectEditorUtils.UniversalVisitor;
import aspectEditor.editors.AspectEditor;
import edu.neu.ccs.demeter.aplib.ClassGraphI;
import edu.neu.ccs.demeter.aplib.TraversalException;
import edu.neu.ccs.demeter.aplib.TraversalGraph;
import edu.neu.ccs.demeter.aplib.cd.ClassGraph;
import edu.neu.ccs.demeter.dj.Strategy;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;

class GraphNodes
extends Simple {
    protected StrategyName strategyname;

    public void interpretExpression(SelectorL s, ClassGraph cg) {
        Enumeration allDeclarations = s.get_strategydef_list().elements();
        Strategy strat = null;
        while (allDeclarations.hasMoreElements()) {
            Object currDeclaration = allDeclarations.nextElement();
            StrategyDef sd = (StrategyDef)currDeclaration;
            if (!this.strategyname.get_name().equals((Object)sd.get_strategyname().get_name())) continue;
            strat = new Strategy(sd.get_strategyexpression().get_strategy().toString());
        }
        TraversalGraph trav = null;
        try {
            trav = new TraversalGraph(strat.toSimpleStrategy(), (ClassGraphI)cg.normalize());
        }
        catch (TraversalException e) {
            AspectEditor.traversalViewer.setText(e.getMessage());
        }
        this.nodesTraversed.addAll(trav.getNodeSets());
        this.edgesTraversed.addAll(trav.getEdgeSets());
        Main.nodesTraversed.addAll(trav.getNodeSets());
        Main.edgesTraversed.addAll(trav.getEdgeSets());
    }

    public StrategyName get_strategyname() {
        return this.strategyname;
    }

    public void set_strategyname(StrategyName new_strategyname) {
        this.strategyname = new_strategyname;
    }

    public GraphNodes() {
    }

    public GraphNodes(StrategyName strategyname) {
        this.set_strategyname(strategyname);
    }

    public static GraphNodes parse(Reader in) throws ParseException {
        return new Parser(in)._GraphNodes();
    }

    public static GraphNodes parse(InputStream in) throws ParseException {
        return new Parser(in)._GraphNodes();
    }

    public static GraphNodes parse(String s) {
        try {
            return GraphNodes.parse(new StringReader(s));
        }
        catch (ParseException e) {
            throw new RuntimeException(e.toString());
        }
    }

    void universal_trv0_bef(UniversalVisitor _v_) {
        super.universal_trv0_bef(_v_);
        _v_.before(this);
    }

    void universal_trv0_aft(UniversalVisitor _v_) {
        _v_.after(this);
        super.universal_trv0_aft(_v_);
    }

    void universal_trv0(UniversalVisitor _v_) {
        this.universal_trv0_bef(_v_);
        _v_.before_strategyname(this, this.strategyname);
        this.strategyname.universal_trv0(_v_);
        _v_.after_strategyname(this, this.strategyname);
        super.universal_trv0(_v_);
        this.universal_trv0_aft(_v_);
    }
}

