/*
 * Decompiled with CFR 0.152.
 */
package aspectEditor.editors;

import aspectEditor.aspectEditorUtils.ClassDictionaryL;
import aspectEditor.aspectEditorUtils.XAspectLanguage2;
import aspectEditor.editors.AspectEditor;
import edu.neu.ccs.demeter.aplib.cd.ClassGraph;
import java.util.Enumeration;
import java.util.HashSet;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;

public class DoubleClickStrategy
implements ITextDoubleClickStrategy {
    protected ITextViewer fText;

    public void doubleClicked(ITextViewer part) {
        int pos = part.getSelectedRange().x;
        if (pos < 0) {
            return;
        }
        this.fText = part;
        if (!this.selectComment(pos)) {
            this.selectWord(pos);
        }
        int cfr_ignored_0 = this.fText.getSelectedRange().x;
        int cfr_ignored_1 = this.fText.getSelectedRange().y;
        this.fText.getTextWidget().getSelectionText().toString();
        String docToParse = AspectEditor.myDoc.get();
        XAspectLanguage2 s = new XAspectLanguage2();
        s = XAspectLanguage2.parse(docToParse);
        HashSet myCDNodeHash = new HashSet();
        Enumeration aspectEnumeration = s.get_aspectlanguage_list().elements();
        String myClass = "";
        while (aspectEnumeration.hasMoreElements()) {
            String cdType = "aspectEditor.aspectEditorUtils.ClassDictionaryL";
            Object currObj = aspectEnumeration.nextElement();
            if (!cdType.equals(currObj.getClass().getName())) continue;
            ClassDictionaryL currDict = (ClassDictionaryL)currObj;
            myClass = currDict.get_classdict().get_text().toString();
            ClassGraph genericCG = ClassGraph.parse((String)myClass);
            myCDNodeHash.addAll(genericCG.getNodes());
        }
    }

    protected boolean selectComment(int caretPos) {
        IDocument doc = this.fText.getDocument();
        try {
            int pos = caretPos;
            int c = 32;
            while (pos >= 0) {
                c = doc.getChar(pos);
                if (c == 92) {
                    pos -= 2;
                    continue;
                }
                if (c == 13 || c == 34) break;
                --pos;
            }
            if (c != 34) {
                return false;
            }
            int startPos = pos;
            pos = caretPos;
            int length = doc.getLength();
            c = 32;
            while (pos < length) {
                c = doc.getChar(pos);
                if (c == 13 || c == 34) break;
                ++pos;
            }
            if (c != 34) {
                return false;
            }
            int endPos = pos;
            int offset = startPos + 1;
            int len = endPos - offset;
            this.fText.setSelectedRange(offset, len);
            return true;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected boolean selectWord(int caretPos) {
        doc = this.fText.getDocument();
        try {
            block6: {
                pos = caretPos;
                pos = caretPos;
                length = doc.getLength();
                while (pos < length) {
                    c = doc.getChar(pos);
                    if (c == ';') break;
                    ++pos;
                }
                pos = endPos = pos;
                if (doc.getChar(pos - 1) != '}') ** GOTO lbl23
                while (pos >= 0) {
                    c = doc.getChar(pos);
                    if (c == '{') {
                        --pos;
                        break block6;
                    }
                    --pos;
                }
                break block6;
                while ((c = doc.getChar(pos)) != ':') {
                    --pos;
lbl23:
                    // 2 sources

                    if (pos >= 0) continue;
                }
            }
            startPos = pos;
            this.selectRange(startPos, endPos);
            return true;
        }
        catch (BadLocationException v0) {
            return false;
        }
    }

    private void selectRange(int startPos, int stopPos) {
        int offset = startPos + 1;
        int length = stopPos - offset;
        this.fText.setSelectedRange(offset, length);
    }
}

