import java.io.*;
import edu.neu.ccs.demeter.*;
 class PrintVisitor extends UniversalVisitor {
  protected int indent;
  public int get_indent() { return indent;   }
  public void set_indent(int new_indent) { indent = new_indent;   }
  protected boolean needSpace;
  public boolean get_needSpace() { return needSpace;   }
  public void set_needSpace(boolean new_needSpace) { needSpace = new_needSpace;   }
  public PrintVisitor() { super();   }
  public PrintVisitor(int indent, boolean needSpace) {
    super();
    set_indent(indent);
    set_needSpace(needSpace);
    }
  
    protected java.io.PrintWriter out = new java.io.PrintWriter(System.out, true);
    java.io.PrintWriter get_out()             { return out; }
    void set_out(java.io.PrintWriter new_out) { out = new_out; }
    PrintVisitor(java.io.PrintWriter out)     { set_out(out); }
    PrintVisitor(java.io.PrintStream out)
      { set_out(new java.io.PrintWriter(out, true)); }
  
  public void finish() { out.flush();   }
  protected void space() {
    if (needSpace) out.print(" ");
    needSpace = false;
    }
  public void before_twobuttonmousebutton(TwoButtonCommand source, TwoButtonMouseButton dest) {
    space();
    out.print("twobutton");
    needSpace = true;
    }
  public void before_threebuttonmousebutton(ThreeButtonCommand source, ThreeButtonMouseButton dest) {
    space();
    out.print("threebutton");
    needSpace = true;
    }
  public void before_wheelmousebutton(WheelButtonCommand source, WheelMouseButton dest) {
    space();
    out.print("wbutton");
    needSpace = true;
    }
  public void before(LeftButton host) {
    space();
    out.print("left");
    needSpace = true;
    }
  public void before(RightButton host) {
    space();
    out.print("right");
    needSpace = true;
    }
  public void before(MiddleButton host) {
    space();
    out.print("middle");
    needSpace = true;
    }
  public void before(WheelButton host) {
    space();
    out.print("wheel");
    needSpace = true;
    }
  public void before(ClickOp host) {
    space();
    out.print("click");
    needSpace = true;
    }
  public void before(PressOp host) {
    space();
    out.print("press");
    needSpace = true;
    }
  public void before(ReleaseOp host) {
    space();
    out.print("release");
    needSpace = true;
    }
  public void before(RollUpOp host) {
    space();
    out.print("roll up");
    needSpace = true;
    }
  public void before(RollDownOp host) {
    space();
    out.print("roll down");
    needSpace = true;
    }
  public void before_mousecoordinate(MouseCoordinates source, MouseCoordinate dest) {
    space();
    out.print("at");
    needSpace = true;
    out.print("(");
    needSpace = false;
    }
  public void after_mousecoordinate(MouseCoordinates source, MouseCoordinate dest) {
    out.print(")");
    needSpace = false;
    }
  public void before_x(PointCoordinate source, int dest) {
    space();
    out.print(source.get_x());
    needSpace = true;
    }
  public void before_y(PointCoordinate source, int dest) {
    out.print(",");
    needSpace = false;
    space();
    out.print(source.get_y());
    needSpace = true;
    }
  public void before_indent(PrintVisitor source, int dest) {
    space();
    out.print(source.get_indent());
    needSpace = true;
    }
  public void before_needSpace(PrintVisitor source, boolean dest) {
    space();
    out.print(source.get_needSpace());
    needSpace = true;
    }
  public void before_copy(CopyVisitor source, Object dest) {
    space();
    out.print(source.get_copy());
    needSpace = true;
    }
  public void before_is_equal(SubgraphVisitor source, boolean dest) {
    space();
    out.print(source.get_is_equal());
    needSpace = true;
    }
  public void before_is_equal(EqualVisitor source, boolean dest) {
    space();
    out.print(source.get_is_equal());
    needSpace = true;
    }
  public void before_indent(DisplayVisitor source, int dest) {
    space();
    out.print(source.get_indent());
    needSpace = true;
    }
  public void before_indent(TraceVisitor source, int dest) {
    space();
    out.print(source.get_indent());
    needSpace = true;
    }
    void universal_trv0_bef(UniversalVisitor _v_) {
    super.universal_trv0_bef(_v_);
  }

    void universal_trv0_aft(UniversalVisitor _v_) {
    super.universal_trv0_aft(_v_);
  }

    void universal_trv0(UniversalVisitor _v_) {
    universal_trv0_bef(_v_);
    super.universal_trv0(_v_);
    universal_trv0_aft(_v_);
  }

}
