import java.io.*;
import edu.neu.ccs.demeter.*;
 class DisplayVisitor extends UniversalVisitor {
  protected int indent;
  public int get_indent() { return indent;   }
  public void set_indent(int new_indent) { indent = new_indent;   }
  public DisplayVisitor() { super();   }
  public DisplayVisitor(int indent) {
    super();
    set_indent(indent);
    }
  
    protected java.io.PrintWriter out = new java.io.PrintWriter(System.out, true);
    java.io.PrintWriter get_out()             { return out; }
    void set_out(java.io.PrintWriter new_out) { out = new_out; }
    DisplayVisitor(java.io.PrintWriter out)     { set_out(out); }
    DisplayVisitor(java.io.PrintStream out)
      { set_out(new java.io.PrintWriter(out, true)); }
  
  public void finish() { out.flush();   }
  public void before(Commands host) {
    out.print(": Commands  (");
    indent++;
    }
  public void after(Commands host) {
    out.print(" )");
    indent--;
    }
  public void before_mousecommandlist(Commands source, MouseCommandList dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<mousecommandlist> ");
    }
  public void before(MouseCommandList host) {
    out.print(": MouseCommandList  (");
    indent++;
    }
  public void after(MouseCommandList host) {
    out.print(" )");
    indent--;
    }
  public void before_mousecommand_list(MouseCommandList source, MouseCommand_List dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<mousecommand_list> ");
    }
  public void before(TwoButtonCommand host) {
    out.print(": TwoButtonCommand  (");
    indent++;
    }
  public void after(TwoButtonCommand host) {
    out.print(" )");
    indent--;
    }
  public void before_twobuttonmousebutton(TwoButtonCommand source, TwoButtonMouseButton dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<twobuttonmousebutton> ");
    }
  public void before_basicoperation(TwoButtonCommand source, BasicOperation dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<basicoperation> ");
    }
  public void before_mousecoordinates(TwoButtonCommand source, MouseCoordinates dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<mousecoordinates> ");
    }
  public void before(ThreeButtonCommand host) {
    out.print(": ThreeButtonCommand  (");
    indent++;
    }
  public void after(ThreeButtonCommand host) {
    out.print(" )");
    indent--;
    }
  public void before_threebuttonmousebutton(ThreeButtonCommand source, ThreeButtonMouseButton dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<threebuttonmousebutton> ");
    }
  public void before_basicoperation(ThreeButtonCommand source, BasicOperation dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<basicoperation> ");
    }
  public void before_mousecoordinates(ThreeButtonCommand source, MouseCoordinates dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<mousecoordinates> ");
    }
  public void before(WheelButtonCommand host) {
    out.print(": WheelButtonCommand  (");
    indent++;
    }
  public void after(WheelButtonCommand host) {
    out.print(" )");
    indent--;
    }
  public void before_wheelmousebutton(WheelButtonCommand source, WheelMouseButton dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<wheelmousebutton> ");
    }
  public void before_advancedoperation(WheelButtonCommand source, AdvancedOperation dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<advancedoperation> ");
    }
  public void before_mousecoordinates(WheelButtonCommand source, MouseCoordinates dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<mousecoordinates> ");
    }
  public void before(TwoButtonMouseButton host) {
    out.print(": TwoButtonMouseButton  (");
    indent++;
    }
  public void after(TwoButtonMouseButton host) {
    out.print(" )");
    indent--;
    }
  public void before_basicbuttons(TwoButtonMouseButton source, BasicButtons dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<basicbuttons> ");
    }
  public void before(ThreeBBasicButtons host) {
    out.print(": ThreeBBasicButtons  (");
    indent++;
    }
  public void after(ThreeBBasicButtons host) {
    out.print(" )");
    indent--;
    }
  public void before_basicbuttons(ThreeBBasicButtons source, BasicButtons dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<basicbuttons> ");
    }
  public void before(WBBasicButtons host) {
    out.print(": WBBasicButtons  (");
    indent++;
    }
  public void after(WBBasicButtons host) {
    out.print(" )");
    indent--;
    }
  public void before_basicbuttons(WBBasicButtons source, BasicButtons dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<basicbuttons> ");
    }
  public void before(LeftButton host) {
    out.print(": LeftButton  (");
    indent++;
    }
  public void after(LeftButton host) {
    out.print(" )");
    indent--;
    }
  public void before(RightButton host) {
    out.print(": RightButton  (");
    indent++;
    }
  public void after(RightButton host) {
    out.print(" )");
    indent--;
    }
  public void before(MiddleButton host) {
    out.print(": MiddleButton  (");
    indent++;
    }
  public void after(MiddleButton host) {
    out.print(" )");
    indent--;
    }
  public void before(WheelButton host) {
    out.print(": WheelButton  (");
    indent++;
    }
  public void after(WheelButton host) {
    out.print(" )");
    indent--;
    }
  public void before(ClickOp host) {
    out.print(": ClickOp  (");
    indent++;
    }
  public void after(ClickOp host) {
    out.print(" )");
    indent--;
    }
  public void before(PressOp host) {
    out.print(": PressOp  (");
    indent++;
    }
  public void after(PressOp host) {
    out.print(" )");
    indent--;
    }
  public void before(ReleaseOp host) {
    out.print(": ReleaseOp  (");
    indent++;
    }
  public void after(ReleaseOp host) {
    out.print(" )");
    indent--;
    }
  public void before(RollUpOp host) {
    out.print(": RollUpOp  (");
    indent++;
    }
  public void after(RollUpOp host) {
    out.print(" )");
    indent--;
    }
  public void before(RollDownOp host) {
    out.print(": RollDownOp  (");
    indent++;
    }
  public void after(RollDownOp host) {
    out.print(" )");
    indent--;
    }
  public void before(MouseCoordinates host) {
    out.print(": MouseCoordinates  (");
    indent++;
    }
  public void after(MouseCoordinates host) {
    out.print(" )");
    indent--;
    }
  public void before_mousecoordinate(MouseCoordinates source, MouseCoordinate dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<mousecoordinate> ");
    }
  public void before(PointCoordinate host) {
    out.print(": PointCoordinate  (");
    indent++;
    }
  public void after(PointCoordinate host) {
    out.print(" )");
    indent--;
    }
  public void before_x(PointCoordinate source, int dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<x> ");
    out.print(" : int \"" + dest + "\"");
    }
  public void before_y(PointCoordinate source, int dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<y> ");
    out.print(" : int \"" + dest + "\"");
    }
  public void before(EmptyCoordinate host) {
    out.print(": EmptyCoordinate  (");
    indent++;
    }
  public void after(EmptyCoordinate host) {
    out.print(" )");
    indent--;
    }
  public void before(Main host) {
    out.print(": Main  (");
    indent++;
    }
  public void after(Main host) {
    out.print(" )");
    indent--;
    }
  public void before(PrintVisitor host) {
    out.print(": PrintVisitor  (");
    indent++;
    }
  public void after(PrintVisitor host) {
    out.print(" )");
    indent--;
    }
  public void before_indent(PrintVisitor source, int dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<indent> ");
    out.print(" : int \"" + dest + "\"");
    }
  public void before_needSpace(PrintVisitor source, boolean dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<needSpace> ");
    out.print(" : boolean \"" + dest + "\"");
    }
  public void before(CopyVisitor host) {
    out.print(": CopyVisitor  (");
    indent++;
    }
  public void after(CopyVisitor host) {
    out.print(" )");
    indent--;
    }
  public void before_copy(CopyVisitor source, Object dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<copy> ");
    }
  public void before(SubgraphVisitor host) {
    out.print(": SubgraphVisitor  (");
    indent++;
    }
  public void after(SubgraphVisitor host) {
    out.print(" )");
    indent--;
    }
  public void before_is_equal(SubgraphVisitor source, boolean dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<is_equal> ");
    out.print(" : boolean \"" + dest + "\"");
    }
  public void before(EqualVisitor host) {
    out.print(": EqualVisitor  (");
    indent++;
    }
  public void after(EqualVisitor host) {
    out.print(" )");
    indent--;
    }
  public void before_is_equal(EqualVisitor source, boolean dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<is_equal> ");
    out.print(" : boolean \"" + dest + "\"");
    }
  public void before(DisplayVisitor host) {
    out.print(": DisplayVisitor  (");
    indent++;
    }
  public void after(DisplayVisitor host) {
    out.print(" )");
    indent--;
    }
  public void before_indent(DisplayVisitor source, int dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<indent> ");
    out.print(" : int \"" + dest + "\"");
    }
  public void before(TraceVisitor host) {
    out.print(": TraceVisitor  (");
    indent++;
    }
  public void after(TraceVisitor host) {
    out.print(" )");
    indent--;
    }
  public void before_indent(TraceVisitor source, int dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<indent> ");
    out.print(" : int \"" + dest + "\"");
    }
  public void before(MouseCommand_List host) {
    out.print(": MouseCommand_List  {");
    indent++;
    }
  public void after(MouseCommand_List host) {
    out.print(" }");
    indent--;
    }
  public void before_first(MouseCommand_List source, Nonempty_MouseCommand_List dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<first> ");
    }
  public void before(Nonempty_MouseCommand_List host) {
    out.print(": Nonempty_MouseCommand_List  (");
    indent++;
    }
  public void after(Nonempty_MouseCommand_List host) {
    out.print(" )");
    indent--;
    }
  public void before_it(Nonempty_MouseCommand_List source, MouseCommand dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<it> ");
    }
  public void before_next(Nonempty_MouseCommand_List source, Nonempty_MouseCommand_List dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<next> ");
    }
    void universal_trv0_bef(UniversalVisitor _v_) {
    super.universal_trv0_bef(_v_);
  }

    void universal_trv0_aft(UniversalVisitor _v_) {
    super.universal_trv0_aft(_v_);
  }

    void universal_trv0(UniversalVisitor _v_) {
    universal_trv0_bef(_v_);
    super.universal_trv0(_v_);
    universal_trv0_aft(_v_);
  }

}
