
import java.util.Iterator;

aspect Total {

    /*
    declare salaryTraversal:         // defines a static method salaryTraversal
        from Company to Salary;      // that takes a Company as an argument

    pointcut traversingSalary(Salary s): 
        traversal(salaryTraversal)
	&& target(s);                // we reach a Salary object
    
    pointcut crossingAdmin(Company c, Object ad):
        traversal(salaryTraversal)
	&& crossing(admin)          // we follow a field named 'admin'
	&& this(c)                  //  in a Company
	&& target(ad);              //  that holds a value of any type
	
    */

    static int total = 0;
    public static int computeTotal(Company c) {
	total = 0;
	salaryTraversal(c);
	return total;
    }

    before(Salary s): traversingSalary(s) {
	System.out.println(" at node " + s);
	System.out.println(" adding " + s.getValue());
	total += s.getValue();
	System.out.println(" current total " + total);
    }

    before(Company c, Object ad): crossingAdmin(c, ad) {
	System.out.println(" at edge source: " + c + " target: " + ad);
    }


    // here is what the declare traversal compiles to:

    public static void salaryTraversal(Company c) {
	c.TRAVERSAL$1();
    }
    

    private void Company.TRAVERSAL$1() {
	TRAVERSAL$1_admin();
	TRAVERSAL$1_devp();
    }
    
    private void Company.TRAVERSAL$1_admin() { admin.TRAVERSAL$1(); }
    private void Company.TRAVERSAL$1_devp()  { devp.TRAVERSAL$1();  }


    private void Dept.TRAVERSAL$1() {
	Iterator iter = employees.iterator();
	while( iter.hasNext() ) {
	    ((Employee)iter.next()).TRAVERSAL$1();
	}
    }
    

    private void Employee.TRAVERSAL$1()   { TRAVERSAL$1_s(); }    
    private void Employee.TRAVERSAL$1_s() { s.TRAVERSAL$1(); }
    
    
    private void Salary.TRAVERSAL$1() { }


    // here is what the pointcuts 'compile to':
    
    pointcut traversingSalary(Salary s): 
	call(void TRAVERSAL$1(..))
	&& target(s);

    pointcut crossingAdmin(Company c, Object ad):
	withincode(void Company.TRAVERSAL$1_admin(..)) &&
	call(* TRAVERSAL$1(..)) &&
	this(c) &&
	target(ad);
}
