/**
  * This class is part of project that implements Aspectual Components
  *
  * Author: Predrag Petkovic, predrag@ccs.neu.edu
  *         Northeastern University
  *
  * This class is internal representation of mapping of the component's
  * participant into application classes.
  * It contains participant's name, vector of the full qualifying names of
  * application classes participant is mapped to and vector of method maps.
  */
package edu.neu.ccs.aspects.map;

import java.util.Vector;

class ParticipantMap {
 
  String participantName = "";

  Vector applicationClassName = new Vector();

  Vector methodMaps = new Vector();

  public String toString() {
    String s = participantName + " -> ";
    for (int i=0; i<applicationClassName.size(); i++) {
      s += (String)applicationClassName.elementAt(i);
      if (i != applicationClassName.size()-1)
	s += ", ";
    }
    s += " {\n";
    for (int i=0; i<methodMaps.size(); i++)
      s += ((MethodMap)methodMaps.elementAt(i)).toString() + "\n";
    s += "}\n";
    return s;
  }
}
