/**
  * This class is part of project that implements Aspectual Components
  *
  * Author: Predrag Petkovic, predrag@ccs.neu.edu
  *         Northeastern University
  *
  * This class is internal representation of the mapping of the participant
  * method. It contains participant's method name and vector of application methods
  * participant method is mapped to.
  */
package edu.neu.ccs.aspects.map;

import java.util.Vector;

class MethodMap {
 
  String participantMethod = "";
  Vector applicationMethods = new Vector(); 

  public String toString() {
    String s = participantMethod + " -> ";
    for (int i=0; i<applicationMethods.size(); i++){
      s += ((ApplicationMethod)applicationMethods.elementAt(i)).toString();
      if (i != applicationMethods.size()-1)
	s += ", ";
    }
    s += ";";
    return s;
  }
}
