/**
  * This class is part of project that implements Aspectual Components
  *
  * Author: Predrag Petkovic, predrag@ccs.neu.edu
  *         Northeastern University
  *
  * This interface represent map that connector which connects
  * application classes and aspectual component uses to do actions
  * based on the deployment map and component itself.
  */
package edu.neu.ccs.aspects.map;

import java.lang.reflect.Method;

public interface Map {
  public Class getParticipantClass(Class applicationClass);
  public Method getBeforeMethod(Method methodToMap, Class applicatioClass);
  public Method getReplacingMethod(Method methodToMap, Class applicationClass);
  public Method getAfterMethod(Method methodToMap, Class applicationClass);
  public Method getExpectedMethod(Method mappedMethod, Class participantClass);
  public Class[] getApplicationClasses();
  public Class getComponentClass();
}
