/**
  * This class is part of project that implements Aspectual Components
  *
  * Author: Predrag Petkovic, predrag@ccs.neu.edu
  *         Northeastern University
  *
  * This class represent one implementation of the Map interface
  * using Hashtables. It is abstract because values in the hashtables
  * need to be initialized by subclass.
  */
package edu.neu.ccs.aspects.map;

import java.lang.reflect.*;
import java.util.*;

abstract class MadeMap implements Map {
  
  public Class getParticipantClass(Class applicationClass) {
    return (Class) application2participant.get(applicationClass);
  }

  public Method getBeforeMethod(Method methodToMap, Class applicationClass) {
    Hashtable methods = (Hashtable) beforeMethods.get(applicationClass);
    if (methods == null)
      return null;
    return (Method) methods.get(methodToMap);
  }

  public Method getReplacingMethod(Method methodToMap, Class applicationClass) {
    Hashtable methods = (Hashtable) replacingMethods.get(applicationClass);
    if (methods == null)
      return null;
    return (Method) methods.get(methodToMap);
  }

  public Method getAfterMethod(Method methodToMap, Class applicationClass) {
    Hashtable methods = (Hashtable) afterMethods.get(applicationClass);
    if (methods == null)
      return null;
    return (Method) methods.get(methodToMap);
  }

  public Method getExpectedMethod(Method mappedMethod, Class participantClass) {
    Hashtable methods = (Hashtable) expectedMethods.get(participantClass);
    if (methods == null)
      return null;
    return (Method) methods.get(mappedMethod);
  }

  public Class[] getApplicationClasses() {
    return applicationClasses;
  }

  public Class getComponentClass() {
    return componentClass;
  }

  public String toString() {
    String s = "";
    s += "component " + componentClass + "\n";
    s += "ApplicationClass -> ParticipantClass\n";

    Object[] applCl =  application2participant.keySet().toArray();

    for (int i=0; i<applCl.length; i++) {

      s += "  " + (Class)applCl[i] + " -> " + 
	(Class)application2participant.get((Class)applCl[i]) + "\n";

      s += "    BeforeMethods:\n";
      Hashtable before = (Hashtable) beforeMethods.get(applCl[i]);
      if (before != null) {
	Object[] beforeM =  before.keySet().toArray();
	for (int j=0; j<beforeM.length; j++)
	  s += "      " + (Method)beforeM[j] + " -> " + 
	    (Method)before.get((Method)beforeM[j]) + "\n";
      }

      s += "    ReplacingMethods:\n";
      Hashtable replacing = (Hashtable) replacingMethods.get(applCl[i]);
      if (replacing != null) {
	Object[] replacingM =  replacing.keySet().toArray();
	for (int j=0; j<replacingM.length; j++)
	  s += "      " + (Method)replacingM[j] + " -> " + 
	    (Method)replacing.get((Method)replacingM[j]) + "\n";
      }

      s += "    AfterMethods:\n";
      Hashtable after = (Hashtable) afterMethods.get(applCl[i]);
      if (after != null) {
	Object[] afterM =  after.keySet().toArray();
	for (int j=0; j<afterM.length; j++)
	  s += "      " + (Method)afterM[j] + " -> " + 
	    (Method)after.get((Method)afterM[j]) + "\n";
      }
    }

    Object[] partCl =  expectedMethods.keySet().toArray();

    for (int i=0; i<partCl.length; i++) {
      s += "  " + (Class)partCl[i] + "\n";
      s += "    ExpectedMethods:\n";
      Hashtable expected = (Hashtable) expectedMethods.get(partCl[i]);
      if (expected != null) {
	Object[] expectedM =  expected.keySet().toArray();
	for (int j=0; j<expectedM.length; j++)
	  s += "      " + (Method)expectedM[j] + " -> " + 
	  (Method)expected.get((Method)expectedM[j]) + "\n";
      }
    }
    return s;
  }

  /**
    * Subclass has to fill up data in these fields
    */

  // 1 -> n mapp (PClass, Vector(AClass))
  protected Hashtable participant2application = new Hashtable(); 
  // 1 -> 1 mapp (AClass, PClass)
  protected Hashtable application2participant = new Hashtable();


  // (AClass, Hash(methodToMap, beforeMethod))
  protected Hashtable beforeMethods = new Hashtable();
  // (AClass, Hash(methodToMap, replacingMethod))
  protected Hashtable replacingMethods = new Hashtable();
  // (AClass, Hash(methodToMap, afterMethod))
  protected Hashtable afterMethods = new Hashtable(); 

  // (PClass, Hash(expectedMethod, mappedMethod))
  protected Hashtable expectedMethods = new Hashtable(); 

  protected Class[] applicationClasses = new Class[]{};

  protected Class componentClass = null;
}
