/**
  * This class is part of project that implements Aspectual Components
  *
  * Author: Predrag Petkovic, predrag@ccs.neu.edu
  *         Northeastern University
  *
  * This class is internal representation of the deployment map.
  * It contains component's name and vector of participant maps.
  */
package edu.neu.ccs.aspects.map;

import java.util.Vector;

class ComponentMap {
 
  String componentName = "";

  Vector participantMaps = new Vector();

  public String toString() {
    String s = "component " + componentName + ";\n";
    s +="{\n";
    for (int i=0; i<participantMaps.size(); i++){
      s += ((ParticipantMap)participantMaps.elementAt(i)).toString() + "\n";
    }
    s+= "}";
    return s;
  }
}
