/**
  * This class is part of project that implements Aspectual Components
  *
  * Author: Predrag Petkovic, predrag@ccs.neu.edu
  *         Northeastern University
  *
  * This class is internal representation of application's method in witch 
  * participant's method is mapp. It contains name, and flags that mark if the name
  * is a preffix or a suffix.
  */

package edu.neu.ccs.aspects.map;

class ApplicationMethod {
 
  String name = "";
  boolean preffix = false;
  boolean suffix = false;

  public String toString() {
    String s = "";
    if (suffix)
      s += "*";
    s += name;
    if (preffix)
      s += "*";
    return s;
  }
}
