/**
  * This class is part of project that implements Aspectual Components
  *
  * Author: Predrag Petkovic, predrag@ccs.neu.edu
  *         Northeastern University
  *
  * This class is responsible for invoking original methods inside the application 
  * classes. After the original application class code is instrumented it will
  * delegate invokation of the method to the instance of the invoker which is member
  * of the application class. Delegation is made by passing the method event, 
  * that contains method to be invoked, arguments and source (object on whome the method
  * will be invoked). Before/after invokation this class fires before/after events
  * to all registered  befeore/after listeners.
  */
package edu.neu.ccs.aspects;

import edu.neu.ccs.beans.reflect.event.MethodEvent;
import edu.neu.ccs.beans.reflect.method.MethodVisitor;

import java.lang.reflect.*;

public class Invoker extends MethodVisitor {

  public Invoker(Class clazz) {
    supportedClass = clazz;
  }
  public Object getReturnValue() {
    return returnValue;
  }
  public void setReturnValue(Object value) {
    returnValue = value;
  }
  public Class getSupportedClass() {
    return supportedClass;
  }

  protected void propagateMethodEvent(MethodEvent event) {
    try {
      Method method = getVisitedMethod();
      Object source = getSource();
      Object[] args = (Object[]) getData();

      returnValue = method.invoke(source, args);
    }
    catch (ClassCastException exception) {
      exception.printStackTrace();
    }
    catch (IllegalAccessException exception) {
      exception.printStackTrace();
    }
    catch (IllegalArgumentException exception) {
      exception.printStackTrace();
    }
    catch (InvocationTargetException exception) {
      exception.printStackTrace();
    }
  }

  private Class supportedClass;
  private Object returnValue = null;
}
