/**
  * This class is part of project that implements Aspectual Components
  *
  * Author: Predrag Petkovic, predrag@ccs.neu.edu
  *         Northeastern University
  *
  */
package edu.neu.ccs.aspects;

import edu.neu.ccs.aspects.map.*;

import java.io.*;

public class Aspect {

  public static Connector connect(String deploymentFileName) throws ConnectingException {
    try {
      InputStream input = new java.io.FileInputStream(deploymentFileName);
      return connect(input);
    }
    catch (FileNotFoundException e) {
      throw new ConnectingException("File " + deploymentFileName + " not found.");
    }
  }

  public static Connector connect(InputStream deployment) throws ConnectingException  {
    try {
      if (parser == null)
	parser = new DeploymentParser(deployment);
      else
	DeploymentParser.ReInit(deployment);
      Map map = Mapper.getMap(parser.Deployment());
      return new AspectConnector(map);
    }
    catch (ParseException p) {
      throw new ConnectingException(p.getMessage());
    }
    catch (MappingException m) {
      throw new ConnectingException(m.getMessage());
    }
  }
  private Aspect(){}
  private static DeploymentParser parser = null;
}
