import application.*;
import edu.neu.ccs.aspects.*;
import components.*;
import deployment.*;

public class PointDemo  {

  
  public static void main(String[] args) throws ConnectingException {
    PointDemo demo = new PointDemo();
    demo.init();
  }
  void init() throws ConnectingException {

    System.out.println("START\n");
    Point point = new Point();

    System.out.println("Setting X");
    point.setX(3);
    System.out.println("Setting Y");
    point.setY(1);
    System.out.println("Getting X");
    System.out.println(point.getX());
    System.out.println("Getting Y");
    System.out.println(point.getY());

    Aspect.connect("deployment/PointAutoReset.dpl");
    System.out.println("\nAutoReset connected\n");

    for (int i=0; i < 52; i++) {
      point.setX(point.getX() + 1);
      point.setY(point.getY() + 2);
      if (i == 48) {
	System.out.println(point.getX());
	System.out.println(point.getY());
      }
    }
    Connector c = Aspect.connect("deployment/PointShowAccesses.dpl");
    System.out.println("\nShowAccesse connected\n");
    System.out.println(point.getX());
    System.out.println(point.getY());

    c.disconnect();
    System.out.println("\nShowAccesse disconnected\n");
    System.out.println(point.getX());
    System.out.println(point.getY());
    
    System.out.println("\nEND");
  }

}
