import EDU.neu.ccs.demeter.dj.*;

class Main {
//the current Directory
private static CDirectory m_fCurrent;
//the main which start the program
public static void main(String args[]){
	Wector w;
	System.out.println("Start simulation.");
	ClassGraph cg = new ClassGraph();
	w = new Wector();
   	w.addElement(new CSimple(new String("test1")));
	w.addElement(new CSimple(new String("test2")));
	CFile test = (CFile) w.elementAt(1);															
	test.print();
	m_fCurrent = new CDirectory(w);
	m_fCurrent.print();

	System.out.println("Create Strategy");
	Strategy sg = new Strategy("from CDirectory to Wector");
	System.out.println("Create TraverslGraph");
	TraversalGraph tg = TraversalGraph.compute(cg, sg);
	System.out.println(tg);
	tg.traverse(m_fCurrent, new duVisitor()); 

	//touch("file1");
	//mkdir("dir1");
	//cdDir("dir1");

	//cdDir("foo");
	//touch("file2");
	//ln("link1", "file2");
	//rm("file2");
	//add du here
	//cdUp();
	//rmdir("dir1");
	//cdDir("dir1");
	//rm("file2");
	//cdUp();
	//rmdir("dir1");

	//du();
	}

	//implement du 
	public static void du()
	{
	   ClassGraph cg = new ClassGraph();
		System.out.println("Create Strategy");
		Strategy sg = new Strategy("from CDirectory to String");
		System.out.println("Create TraverslGraph");
		TraversalGraph tg = TraversalGraph.compute(cg, sg);
		System.out.println(tg);
		tg.traverse(m_fCurrent, new Visitor() 
		{
	
			public void before(CFile o){o.print();}
			public void before(CSimple o){o.print();}
			public void before(CDirectory o){o.print();}
			public void before(CLink o){o.print();}
		});
	}

	//implement the ln command
	public static void ln(String szName, String szTarget){
		System.out.println(">ln " + szName + " " + szTarget);
		m_fCurrent.AddSub(new CLink(szName, szTarget));
	
	}
	
	//implement the touch command
	public static  void touch(String szName){
		System.out.println(">touch " + szName);
		m_fCurrent.AddSub(new CSimple(szName));
	}
	//implements the mkdir command
	public static void mkdir(String szNew){
		Wector w;
		w = new Wector();
		System.out.println(">mkdir " + szNew);
		m_fCurrent.AddSub(new CDirectory(w));
		

	}
	//implement the cd .. command
	public static void cdUp(){
		CDirectory fOld;
		System.out.println(">cd ..");
		fOld = m_fCurrent;
		//m_fCurrent = m_fCurrent.Get_Parent();
		//if(m_fCurrent == null)
		//{
		//	System.out.println("no higher directory");
		//	m_fCurrent = fOld;
		//}
	}

	// implement the cd <dir> command
	public static void cdDir(String szDir){
		CDirectory fOld;
		System.out.println(">cd  " + szDir);
		fOld = m_fCurrent;
		m_fCurrent = m_fCurrent.FindDir(szDir);
		if(m_fCurrent == null)
		{
			m_fCurrent = fOld;
			System.out.println("Directory not found");
		}
	}
	
	// removes file form current Directory
	public static void rm(String szName){
		System.out.println(">rm " + szName);
		m_fCurrent.RemoveFile(szName);
	}
	
	//removes Directory, if it is empty, else prints error
	public static void rmdir(String szName){
		System.out.println(">rmdir " + szName);
		m_fCurrent.RemoveDir(szName);
	}
}
