import EDU.neu.ccs.demeter.dj.*;
import java.util.Stack;

class CShell {
//the current Directory
private static CDirectory m_fCurrent;
private static CDirectory m_fHome;
public static Stack m_fPrev;
public static ClassGraph cg;
//the main which start the program
public static void main(String args[]){
	System.out.println("Start simulation.");
	m_fPrev = new Stack();
	cg = new ClassGraph();	
	m_fCurrent = new CDirectory("home");
   	m_fHome = m_fCurrent;
	touch("file1");
	mkdir("dir1");
	cdDir("foo");
	mkdir("foo");
	cdDir("foo");
	touch("foo2");
	cdUp();
	du();
	dua();
	cdDir("dir1");
	touch("file2");
	ln("link1", "file2");
	touch("file3");
	du();
	dua();
	rm("file2");
	dua();
	cdUp();
	find("file3");
	du();
	cpr(m_fCurrent, "foonew");
	rmdir("dir1");
	cdDir("dir1");
	rm("link1");
	rm("file3");
	cdUp();
	rmdir("dir1");
	du();
	dua();
	echo();
	
	}


	//implement Recursive copy
	public static void cpr(CDirectory fOld, String szNew)
	{
		System.out.println(">cp -r " + fOld.Get_Name() +" "+ szNew);	
		//ClassGraph cg = new ClassGraph();
		//System.out.println(cg);
		//System.out.println("Create Strategy");
		Strategy sg = new Strategy("from CDirectory to CSimple");
		//System.out.println("Create TraverslGraph");
		TraversalGraph tg = TraversalGraph.compute(cg, sg);
		//System.out.println(tg);
		CDirectory fNew;
		fNew = new CDirectory(szNew);
		tg.traverse(fOld, new cpVisitor(fNew));
		m_fCurrent.AddSub( fNew);

	}
	//implement Find
	public static void find(String szname)
	{
		System.out.println(">find " + szname);
		//ClassGraph cg = new ClassGraph();
		//System.out.println(cg);
		//System.out.println("Create Strategy");
		Strategy sg = new Strategy("from CDirectory to CSimple");
		//System.out.println("Create TraverslGraph");
		TraversalGraph tg = TraversalGraph.compute(cg, sg);
		//System.out.println(tg);
		tg.traverse(m_fCurrent, new findVisitor(szname));
		}

	//implement du 
	public static void du()
	{
		System.out.println(">du");
		ClassGraph cg = new ClassGraph();
		//System.out.println(cg);
		//System.out.println("Create Strategy");
		Strategy sg = new Strategy("from CDirectory bypassing {CSimple, CLink} to String");
		//System.out.println("Create TraverslGraph");
		TraversalGraph tg = TraversalGraph.compute(cg, sg);
		//System.out.println(tg);
		tg.traverse(m_fCurrent, new duVisitor());
		}

	//implement du -a 
	public static void dua()
	{
		System.out.println(">du -a");
		//ClassGraph cg = new ClassGraph();
		//System.out.println(cg);
		//System.out.println("Create Strategy");
		Strategy sg = new Strategy("from CDirectory to String");
		//System.out.println("Create TraverslGraph");
		TraversalGraph tg = TraversalGraph.compute(cg, sg);
		//System.out.println(tg);
		tg.traverse(m_fCurrent, new duVisitor());
	}

	//implement echo $HOME
	public static void echo()
	{
		System.out.println(">echo $HOME");
		System.out.println(m_fHome.Get_Name());
	}

	//implement the ln command
	public static void ln(String szName, String szTarget){
		System.out.println(">ln " + szName + " " + szTarget);
		m_fCurrent.AddSub(new CLink(szName, szTarget));
	
	}
	
	//implement the touch command
	public static  void touch(String szName){
		System.out.println(">touch " + szName);
		m_fCurrent.AddSub(new CSimple(szName));
	}
	//implements the mkdir command
	public static void mkdir(String szNew){
		System.out.println(">mkdir " + szNew);
		m_fCurrent.AddSub(new CDirectory(szNew));
		

	}
	//implement the cd .. command
	public static void cdUp()
	{
		System.out.println(">cd ..");
		if(m_fPrev.empty())
		{
			System.out.println("no higher directory");
		}
		else
		{
			//System.out.println("test");
			m_fCurrent = (CDirectory) m_fPrev.peek();
			//System.out.println("Test2");
			m_fPrev.pop();
			//System.out.println("test3");
		}
	}

	// implement the cd <dir> command
	public static void cdDir(String szDir){
		CDirectory fOld;
		System.out.println(">cd " + szDir);
		fOld = m_fCurrent;
		m_fCurrent = m_fCurrent.FindDir(szDir);
		if(m_fCurrent == null)
		{
			m_fCurrent = fOld;
			System.out.println("Directory not found");
		}
		else
		{
			//System.out.println(fOld.m_szName);
			m_fPrev.push(fOld);
			//System.out.println("test6");
		}
		//System.out.println("finishe");
	}
	
	// removes file form current Directory
	public static void rm(String szName){
		System.out.println(">rm " + szName);
		m_fCurrent.RemoveFile(szName);
	}
	
	//removes Directory, if it is empty, else prints error
	public static void rmdir(String szName){
		System.out.println(">rmdir " + szName);
		m_fCurrent.RemoveDir(szName);
	}
}
