import java.lang.*;
import java.io.*;
import java.util.*;
import EDU.neu.ccs.demeter.*;
 class PrintVisitor extends UniversalVisitor {
  protected int indent;
  public int get_indent() { return indent;   }
  public void set_indent(int new_indent) { indent = new_indent;   }
  protected boolean needSpace;
  public boolean get_needSpace() { return needSpace;   }
  public void set_needSpace(boolean new_needSpace) { needSpace = new_needSpace;   }
  public PrintVisitor() { super();   }
  public PrintVisitor(int indent, boolean needSpace) {
    super();
    set_indent(indent);
    set_needSpace(needSpace);
    }
  
    protected java.io.PrintWriter out = new java.io.PrintWriter(System.out, true);
    java.io.PrintWriter get_out()             { return out; }
    void set_out(java.io.PrintWriter new_out) { out = new_out; }
    PrintVisitor(java.io.PrintWriter out)     { set_out(out); }
    PrintVisitor(java.io.PrintStream out)
      { set_out(new java.io.PrintWriter(out, true)); }
  
  public void finish() { out.flush();   }
  protected void space() {
    if (needSpace) out.print(" ");
    needSpace = false;
    }
  public void before_url(Url source, String dest) {
    space();
    out.print("url(");
    needSpace = false;
    space();
    out.print("\"" + source.get_url() + "\"");
    needSpace = true;
    }
  public void after_url(Url source, String dest) {
    out.print(")");
    needSpace = false;
    }
  public void before_timeout(TimeOut source, float dest) {
    space();
    out.print("timeout(");
    needSpace = false;
    space();
    out.print(source.get_timeout());
    needSpace = true;
    }
  public void before_service(TimeOut source, Service dest) {
    out.print(",");
    needSpace = false;
    }
  public void after_service(TimeOut source, Service dest) {
    out.print(")");
    needSpace = false;
    }
  public void before_service(Repeat source, Service dest) {
    space();
    out.print("repeat(");
    needSpace = false;
    }
  public void after_service(Repeat source, Service dest) {
    out.print(")");
    needSpace = false;
    }
  public void before_main(Alternative source, Service dest) {
    space();
    out.print("alternative(");
    needSpace = false;
    }
  public void before_alternate(Alternative source, Service dest) {
    out.print("?");
    needSpace = false;
    }
  public void after_alternate(Alternative source, Service dest) {
    out.print(")");
    needSpace = false;
    }
  public void before_service1(Concurrent source, Service dest) {
    space();
    out.print("concurrent(");
    needSpace = false;
    }
  public void before_service2(Concurrent source, Service dest) {
    out.print("|");
    needSpace = false;
    }
  public void after_service2(Concurrent source, Service dest) {
    out.print(")");
    needSpace = false;
    }
  public void before_indent(PrintVisitor source, int dest) {
    space();
    out.print(source.get_indent());
    needSpace = true;
    }
  public void before_needSpace(PrintVisitor source, boolean dest) {
    space();
    out.print(source.get_needSpace());
    needSpace = true;
    }
  public void before_copy(CopyVisitor source, Object dest) {
    space();
    out.print(source.get_copy());
    needSpace = true;
    }
  public void before_is_equal(SubgraphVisitor source, boolean dest) {
    space();
    out.print(source.get_is_equal());
    needSpace = true;
    }
  public void before_is_equal(EqualVisitor source, boolean dest) {
    space();
    out.print(source.get_is_equal());
    needSpace = true;
    }
  public void before_indent(DisplayVisitor source, int dest) {
    space();
    out.print(source.get_indent());
    needSpace = true;
    }
  public void before_indent(TraceVisitor source, int dest) {
    space();
    out.print(source.get_indent());
    needSpace = true;
    }
    void universal_trv0_bef(UniversalVisitor _v_) {
    super.universal_trv0_bef(_v_);
  }

    void universal_trv0_aft(UniversalVisitor _v_) {
    super.universal_trv0_aft(_v_);
  }

    void universal_trv0(UniversalVisitor _v_) {
    universal_trv0_bef(_v_);
    super.universal_trv0(_v_);
    universal_trv0_aft(_v_);
  }

}
