import java.lang.*;
import java.io.*;
import java.util.*;
import EDU.neu.ccs.demeter.*;
 class DisplayVisitor extends UniversalVisitor {
  protected int indent;
  public int get_indent() { return indent;   }
  public void set_indent(int new_indent) { indent = new_indent;   }
  public DisplayVisitor() { super();   }
  public DisplayVisitor(int indent) {
    super();
    set_indent(indent);
    }
  
    protected java.io.PrintWriter out = new java.io.PrintWriter(System.out, true);
    java.io.PrintWriter get_out()             { return out; }
    void set_out(java.io.PrintWriter new_out) { out = new_out; }
    DisplayVisitor(java.io.PrintWriter out)     { set_out(out); }
    DisplayVisitor(java.io.PrintStream out)
      { set_out(new java.io.PrintWriter(out, true)); }
  
  public void finish() { out.flush();   }
  public void before(WebScript host) {
    out.print(": WebScript  (");
    indent++;
    }
  public void after(WebScript host) {
    out.print(" )");
    indent--;
    }
  public void before_service_list(WebScript source, Service_List dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<service_list> ");
    }
  public void before(Url host) {
    out.print(": Url  (");
    indent++;
    }
  public void after(Url host) {
    out.print(" )");
    indent--;
    }
  public void before_url(Url source, String dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<url> ");
    out.print(" : String");
    out.print(" \"" + source.get_url() + "\" ");
    }
  public void before(TimeOut host) {
    out.print(": TimeOut  (");
    indent++;
    }
  public void after(TimeOut host) {
    out.print(" )");
    indent--;
    }
  public void before_timeout(TimeOut source, float dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<timeout> ");
    out.print(" : float \"" + dest + "\"");
    }
  public void before_service(TimeOut source, Service dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<service> ");
    }
  public void before(Repeat host) {
    out.print(": Repeat  (");
    indent++;
    }
  public void after(Repeat host) {
    out.print(" )");
    indent--;
    }
  public void before_service(Repeat source, Service dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<service> ");
    }
  public void before(Alternative host) {
    out.print(": Alternative  (");
    indent++;
    }
  public void after(Alternative host) {
    out.print(" )");
    indent--;
    }
  public void before_main(Alternative source, Service dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<main> ");
    }
  public void before_alternate(Alternative source, Service dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<alternate> ");
    }
  public void before(Concurrent host) {
    out.print(": Concurrent  (");
    indent++;
    }
  public void after(Concurrent host) {
    out.print(" )");
    indent--;
    }
  public void before_service1(Concurrent source, Service dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<service1> ");
    }
  public void before_service2(Concurrent source, Service dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<service2> ");
    }
  public void before(Main host) {
    out.print(": Main  (");
    indent++;
    }
  public void after(Main host) {
    out.print(" )");
    indent--;
    }
  public void before(PrintVisitor host) {
    out.print(": PrintVisitor  (");
    indent++;
    }
  public void after(PrintVisitor host) {
    out.print(" )");
    indent--;
    }
  public void before_indent(PrintVisitor source, int dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<indent> ");
    out.print(" : int \"" + dest + "\"");
    }
  public void before_needSpace(PrintVisitor source, boolean dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<needSpace> ");
    out.print(" : boolean \"" + dest + "\"");
    }
  public void before(CopyVisitor host) {
    out.print(": CopyVisitor  (");
    indent++;
    }
  public void after(CopyVisitor host) {
    out.print(" )");
    indent--;
    }
  public void before_copy(CopyVisitor source, Object dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<copy> ");
    }
  public void before(SubgraphVisitor host) {
    out.print(": SubgraphVisitor  (");
    indent++;
    }
  public void after(SubgraphVisitor host) {
    out.print(" )");
    indent--;
    }
  public void before_is_equal(SubgraphVisitor source, boolean dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<is_equal> ");
    out.print(" : boolean \"" + dest + "\"");
    }
  public void before(EqualVisitor host) {
    out.print(": EqualVisitor  (");
    indent++;
    }
  public void after(EqualVisitor host) {
    out.print(" )");
    indent--;
    }
  public void before_is_equal(EqualVisitor source, boolean dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<is_equal> ");
    out.print(" : boolean \"" + dest + "\"");
    }
  public void before(DisplayVisitor host) {
    out.print(": DisplayVisitor  (");
    indent++;
    }
  public void after(DisplayVisitor host) {
    out.print(" )");
    indent--;
    }
  public void before_indent(DisplayVisitor source, int dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<indent> ");
    out.print(" : int \"" + dest + "\"");
    }
  public void before(TraceVisitor host) {
    out.print(": TraceVisitor  (");
    indent++;
    }
  public void after(TraceVisitor host) {
    out.print(" )");
    indent--;
    }
  public void before_indent(TraceVisitor source, int dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<indent> ");
    out.print(" : int \"" + dest + "\"");
    }
  public void before(Service_List host) {
    out.print(": Service_List  {");
    indent++;
    }
  public void after(Service_List host) {
    out.print(" }");
    indent--;
    }
  public void before_first(Service_List source, Nonempty_Service_List dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<first> ");
    }
  public void before(Nonempty_Service_List host) {
    out.print(": Nonempty_Service_List  (");
    indent++;
    }
  public void after(Nonempty_Service_List host) {
    out.print(" )");
    indent--;
    }
  public void before_it(Nonempty_Service_List source, Service dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<it> ");
    }
  public void before_next(Nonempty_Service_List source, Nonempty_Service_List dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<next> ");
    }
    void universal_trv0_bef(UniversalVisitor _v_) {
    super.universal_trv0_bef(_v_);
  }

    void universal_trv0_aft(UniversalVisitor _v_) {
    super.universal_trv0_aft(_v_);
  }

    void universal_trv0(UniversalVisitor _v_) {
    universal_trv0_bef(_v_);
    super.universal_trv0(_v_);
    universal_trv0_aft(_v_);
  }

}
