
import java.awt.*;
import java.io.*;
import java.util.*;
import java.lang.Math ;

import demeter.*;
class UGraph implements Cloneable {
  private UVertex_List vertices;
  public UVertex_List get_vertices() { return vertices; }
  public void set_vertices(UVertex_List new_vertices)
    { vertices = new_vertices; }
  private UEdge_List edges;
  public UEdge_List get_edges() { return edges; }
  public void set_edges(UEdge_List new_edges)
    { edges = new_edges; }
  UGraph() { }
  public UGraph(UVertex_List vertices, UEdge_List edges) {
    super();
    set_vertices(vertices);
    set_edges(edges);
  }
  public static UGraph parse(java.io.InputStream in) throws ParseError
    { return new Parser(in)._UGraph(); }
  public static UGraph parse(String str) throws ParseError
    { return parse(new java.io.StringBufferInputStream(str)); }

     public String PrintVertices()
     { 
        
        ReadVertexVisitor rvv= new ReadVertexVisitor(this, new String(), new Integer(0));
        this.ReadAllVertices(rvv);
        return rvv.get_graphstring();
     }
     public String FindVertex(Integer vertexid)
     { 
        ReadVertexVisitor rvv= new 
		ReadVertexVisitor(this, new String(), vertexid);
        this.ReadAllVertices(rvv);
        return rvv.get_graphstring();
     }
     
     public String FindEdge(Integer vertexid, String fromvertextype)
     { 
	// We will use this string fromvertextype to differentiate
	// if this function was called from an alt or a const vertex
	// The Integer is for the pipeswitch
        ReadEdgeVisitor rev= 
	  new ReadEdgeVisitor(this, new String(), new String(), vertexid, fromvertextype, new Integer(0));
        this.ReadAllEdges(rev);
        String tmp = new String();
	tmp = rev.get_graphstring();
	if ( ! rev.get_commonstring().equals("") ) {
	  tmp = tmp + "\n\t\t*common*\n\t\t" + rev.get_commonstring();
        }
        return tmp;
     }
       public void ReadAllVertices(ReadVertexVisitor rvv)
    { ReadAllVertices_trv1(rvv); }
  public void ReadAllVertices_trv1(ReadVertexVisitor rvv) {
    vertices.ReadAllVertices_trv1(rvv);
  }
  public void ReadAllEdges(ReadEdgeVisitor rev)
    { ReadAllEdges_trv2(rev); }
  public void ReadAllEdges_trv2(ReadEdgeVisitor rev) {
    edges.ReadAllEdges_trv2(rev);
  }
}

class UVertex_List implements Cloneable {
  private Nonempty_UVertex_List first;
  public Nonempty_UVertex_List get_first() { return first; }
  public void set_first(Nonempty_UVertex_List new_first)
    { first = new_first; }
  UVertex_List() { }
  public UVertex_List(Nonempty_UVertex_List first) {
    super();
    set_first(first);
  }
  public static UVertex_List parse(java.io.InputStream in) throws ParseError
    { return new Parser(in)._UVertex_List(); }
  public static UVertex_List parse(String str) throws ParseError
    { return parse(new java.io.StringBufferInputStream(str)); }
  public void ReadAllVertices_trv1(ReadVertexVisitor rvv) {
    if (first != null) {
      first.ReadAllVertices_trv1(rvv);
    }
  }
}

abstract class UVertex implements Cloneable {
  private UID vid;
  public UID get_vid() { return vid; }
  public void set_vid(UID new_vid)
    { vid = new_vid; }
  private UVertexName vertexname;
  public UVertexName get_vertexname() { return vertexname; }
  public void set_vertexname(UVertexName new_vertexname)
    { vertexname = new_vertexname; }
  private Coordinates position;
  public Coordinates get_position() { return position; }
  public void set_position(Coordinates new_position)
    { position = new_position; }
  private IEdge_List incoming;
  public IEdge_List get_incoming() { return incoming; }
  public void set_incoming(IEdge_List new_incoming)
    { incoming = new_incoming; }
  private OEdge_List outgoing;
  public OEdge_List get_outgoing() { return outgoing; }
  public void set_outgoing(OEdge_List new_outgoing)
    { outgoing = new_outgoing; }
  private Decorator vdeco;
  public Decorator get_vdeco() { return vdeco; }
  public void set_vdeco(Decorator new_vdeco)
    { vdeco = new_vdeco; }
  UVertex() { }
  public UVertex(UID vid, UVertexName vertexname, Coordinates position, IEdge_List incoming, OEdge_List outgoing, Decorator vdeco) {
    super();
    set_vid(vid);
    set_vertexname(vertexname);
    set_position(position);
    set_incoming(incoming);
    set_outgoing(outgoing);
    set_vdeco(vdeco);
  }
  public void ReadAllVertices_trv1(ReadVertexVisitor rvv) {
  }
}

class IEdge_List implements Cloneable {
  private Nonempty_IEdge_List first;
  public Nonempty_IEdge_List get_first() { return first; }
  public void set_first(Nonempty_IEdge_List new_first)
    { first = new_first; }
  IEdge_List() { }
  public IEdge_List(Nonempty_IEdge_List first) {
    super();
    set_first(first);
  }
  public static IEdge_List parse(java.io.InputStream in) throws ParseError
    { return new Parser(in)._IEdge_List(); }
  public static IEdge_List parse(String str) throws ParseError
    { return parse(new java.io.StringBufferInputStream(str)); }
}

class OEdge_List implements Cloneable {
  private Nonempty_OEdge_List first;
  public Nonempty_OEdge_List get_first() { return first; }
  public void set_first(Nonempty_OEdge_List new_first)
    { first = new_first; }
  OEdge_List() { }
  public OEdge_List(Nonempty_OEdge_List first) {
    super();
    set_first(first);
  }
  public static OEdge_List parse(java.io.InputStream in) throws ParseError
    { return new Parser(in)._OEdge_List(); }
  public static OEdge_List parse(String str) throws ParseError
    { return parse(new java.io.StringBufferInputStream(str)); }
}

class UConstVertex extends UVertex implements Cloneable {
  UConstVertex() { }
  public UConstVertex(UID vid, UVertexName vertexname, Coordinates position, IEdge_List incoming, OEdge_List outgoing, Decorator vdeco) {
    super(vid, vertexname, position, incoming, outgoing, vdeco);
  }
  public static UConstVertex parse(java.io.InputStream in) throws ParseError
    { return new Parser(in)._UConstVertex(); }
  public static UConstVertex parse(String str) throws ParseError
    { return parse(new java.io.StringBufferInputStream(str)); }
  public void ReadAllVertices_trv1(ReadVertexVisitor rvv) {
    rvv.before(this);
  }
}

class UAltVertex extends UVertex implements Cloneable {
  UAltVertex() { }
  public UAltVertex(UID vid, UVertexName vertexname, Coordinates position, IEdge_List incoming, OEdge_List outgoing, Decorator vdeco) {
    super(vid, vertexname, position, incoming, outgoing, vdeco);
  }
  public static UAltVertex parse(java.io.InputStream in) throws ParseError
    { return new Parser(in)._UAltVertex(); }
  public static UAltVertex parse(String str) throws ParseError
    { return parse(new java.io.StringBufferInputStream(str)); }
  public void ReadAllVertices_trv1(ReadVertexVisitor rvv) {
    rvv.before(this);
  }
}

class UTerm extends UVertex implements Cloneable {
  UTerm() { }
  public UTerm(UID vid, UVertexName vertexname, Coordinates position, IEdge_List incoming, OEdge_List outgoing, Decorator vdeco) {
    super(vid, vertexname, position, incoming, outgoing, vdeco);
  }
  public static UTerm parse(java.io.InputStream in) throws ParseError
    { return new Parser(in)._UTerm(); }
  public static UTerm parse(String str) throws ParseError
    { return parse(new java.io.StringBufferInputStream(str)); }
  public void ReadAllVertices_trv1(ReadVertexVisitor rvv) {
  }
}

class UEdge_List implements Cloneable {
  private Nonempty_UEdge_List first;
  public Nonempty_UEdge_List get_first() { return first; }
  public void set_first(Nonempty_UEdge_List new_first)
    { first = new_first; }
  UEdge_List() { }
  public UEdge_List(Nonempty_UEdge_List first) {
    super();
    set_first(first);
  }
  public static UEdge_List parse(java.io.InputStream in) throws ParseError
    { return new Parser(in)._UEdge_List(); }
  public static UEdge_List parse(String str) throws ParseError
    { return parse(new java.io.StringBufferInputStream(str)); }
  public void ReadAllEdges_trv2(ReadEdgeVisitor rev) {
    if (first != null) {
      first.ReadAllEdges_trv2(rev);
    }
  }
}

abstract class UEdge implements Cloneable {
  private UID eid;
  public UID get_eid() { return eid; }
  public void set_eid(UID new_eid)
    { eid = new_eid; }
  private Decorator edeco;
  public Decorator get_edeco() { return edeco; }
  public void set_edeco(Decorator new_edeco)
    { edeco = new_edeco; }
  private UID fromVertex;
  public UID get_fromVertex() { return fromVertex; }
  public void set_fromVertex(UID new_fromVertex)
    { fromVertex = new_fromVertex; }
  private UID toVertex;
  public UID get_toVertex() { return toVertex; }
  public void set_toVertex(UID new_toVertex)
    { toVertex = new_toVertex; }
  UEdge() { }
  public UEdge(UID eid, Decorator edeco, UID fromVertex, UID toVertex) {
    super();
    set_eid(eid);
    set_edeco(edeco);
    set_fromVertex(fromVertex);
    set_toVertex(toVertex);
  }
  public void ReadAllEdges_trv2(ReadEdgeVisitor rev) {
  }
}

class UAltEdge extends UEdge implements Cloneable {
  UAltEdge() { }
  public UAltEdge(UID eid, Decorator edeco, UID fromVertex, UID toVertex) {
    super(eid, edeco, fromVertex, toVertex);
  }
  public static UAltEdge parse(java.io.InputStream in) throws ParseError
    { return new Parser(in)._UAltEdge(); }
  public static UAltEdge parse(String str) throws ParseError
    { return parse(new java.io.StringBufferInputStream(str)); }
  public void ReadAllEdges_trv2(ReadEdgeVisitor rev) {
    rev.before(this);
  }
}

class UConstEdge extends UEdge implements Cloneable {
  private UEdgeName edgename;
  public UEdgeName get_edgename() { return edgename; }
  public void set_edgename(UEdgeName new_edgename)
    { edgename = new_edgename; }
  private Cardinality card;
  public Cardinality get_card() { return card; }
  public void set_card(Cardinality new_card)
    { card = new_card; }
  UConstEdge() { }
  public UConstEdge(UID eid, Decorator edeco, UID fromVertex, UID toVertex, UEdgeName edgename, Cardinality card) {
    super(eid, edeco, fromVertex, toVertex);
    set_edgename(edgename);
    set_card(card);
  }
  public static UConstEdge parse(java.io.InputStream in) throws ParseError
    { return new Parser(in)._UConstEdge(); }
  public static UConstEdge parse(String str) throws ParseError
    { return parse(new java.io.StringBufferInputStream(str)); }
  public void ReadAllEdges_trv2(ReadEdgeVisitor rev) {
    rev.before(this);
  }
}

class Cardinality implements Cloneable {
  private Lower lower;
  public Lower get_lower() { return lower; }
  public void set_lower(Lower new_lower)
    { lower = new_lower; }
  private Upper upper;
  public Upper get_upper() { return upper; }
  public void set_upper(Upper new_upper)
    { upper = new_upper; }
  Cardinality() { }
  public Cardinality(Lower lower, Upper upper) {
    super();
    set_lower(lower);
    set_upper(upper);
  }
  public static Cardinality parse(java.io.InputStream in) throws ParseError
    { return new Parser(in)._Cardinality(); }
  public static Cardinality parse(String str) throws ParseError
    { return parse(new java.io.StringBufferInputStream(str)); }
}

class Lower implements Cloneable {
  private Integer l;
  public Integer get_l() { return l; }
  public void set_l(Integer new_l)
    { l = new_l; }
  Lower() { }
  public Lower(Integer l) {
    super();
    set_l(l);
  }
  public static Lower parse(java.io.InputStream in) throws ParseError
    { return new Parser(in)._Lower(); }
  public static Lower parse(String str) throws ParseError
    { return parse(new java.io.StringBufferInputStream(str)); }
}

class Upper implements Cloneable {
  private String u;
  public String get_u() { return u; }
  public void set_u(String new_u)
    { u = new_u; }
  Upper() { }
  public Upper(String u) {
    super();
    set_u(u);
  }
  public static Upper parse(java.io.InputStream in) throws ParseError
    { return new Parser(in)._Upper(); }
  public static Upper parse(String str) throws ParseError
    { return parse(new java.io.StringBufferInputStream(str)); }
}

class UID implements Cloneable {
  private Integer id;
  public Integer get_id() { return id; }
  public void set_id(Integer new_id)
    { id = new_id; }
  UID() { }
  public UID(Integer id) {
    super();
    set_id(id);
  }
  public static UID parse(java.io.InputStream in) throws ParseError
    { return new Parser(in)._UID(); }
  public static UID parse(String str) throws ParseError
    { return parse(new java.io.StringBufferInputStream(str)); }
}

class UEdgeName implements Cloneable {
  private Ident name;
  public Ident get_name() { return name; }
  public void set_name(Ident new_name)
    { name = new_name; }
  UEdgeName() { }
  public UEdgeName(Ident name) {
    super();
    set_name(name);
  }
  public static UEdgeName parse(java.io.InputStream in) throws ParseError
    { return new Parser(in)._UEdgeName(); }
  public static UEdgeName parse(String str) throws ParseError
    { return parse(new java.io.StringBufferInputStream(str)); }
}

class UVertexName implements Cloneable {
  private Ident name;
  public Ident get_name() { return name; }
  public void set_name(Ident new_name)
    { name = new_name; }
  UVertexName() { }
  public UVertexName(Ident name) {
    super();
    set_name(name);
  }
  public static UVertexName parse(java.io.InputStream in) throws ParseError
    { return new Parser(in)._UVertexName(); }
  public static UVertexName parse(String str) throws ParseError
    { return parse(new java.io.StringBufferInputStream(str)); }
}

class Coordinates implements Cloneable {
  private X x;
  public X get_x() { return x; }
  public void set_x(X new_x)
    { x = new_x; }
  private Y y;
  public Y get_y() { return y; }
  public void set_y(Y new_y)
    { y = new_y; }
  Coordinates() { }
  public Coordinates(X x, Y y) {
    super();
    set_x(x);
    set_y(y);
  }
  public static Coordinates parse(java.io.InputStream in) throws ParseError
    { return new Parser(in)._Coordinates(); }
  public static Coordinates parse(String str) throws ParseError
    { return parse(new java.io.StringBufferInputStream(str)); }
}

class X implements Cloneable {
  private Integer x;
  public Integer get_x() { return x; }
  public void set_x(Integer new_x)
    { x = new_x; }
  X() { }
  public X(Integer x) {
    super();
    set_x(x);
  }
  public static X parse(java.io.InputStream in) throws ParseError
    { return new Parser(in)._X(); }
  public static X parse(String str) throws ParseError
    { return parse(new java.io.StringBufferInputStream(str)); }
}

class Y implements Cloneable {
  private Integer y;
  public Integer get_y() { return y; }
  public void set_y(Integer new_y)
    { y = new_y; }
  Y() { }
  public Y(Integer y) {
    super();
    set_y(y);
  }
  public static Y parse(java.io.InputStream in) throws ParseError
    { return new Parser(in)._Y(); }
  public static Y parse(String str) throws ParseError
    { return parse(new java.io.StringBufferInputStream(str)); }
}

class Decorator implements Cloneable {
  private TravTag tag;
  public TravTag get_tag() { return tag; }
  public void set_tag(TravTag new_tag)
    { tag = new_tag; }
  private Attributes_PList attributes_plist;
  public Attributes_PList get_attributes_plist() { return attributes_plist; }
  public void set_attributes_plist(Attributes_PList new_attributes_plist)
    { attributes_plist = new_attributes_plist; }
  Decorator() { }
  public Decorator(TravTag tag, Attributes_PList attributes_plist) {
    super();
    set_tag(tag);
    set_attributes_plist(attributes_plist);
  }
  public static Decorator parse(java.io.InputStream in) throws ParseError
    { return new Parser(in)._Decorator(); }
  public static Decorator parse(String str) throws ParseError
    { return parse(new java.io.StringBufferInputStream(str)); }
}

class Attributes implements Cloneable {
  private Integer integer;
  public Integer get_integer() { return integer; }
  public void set_integer(Integer new_integer)
    { integer = new_integer; }
  Attributes() { }
  public Attributes(Integer integer) {
    super();
    set_integer(integer);
  }
  public static Attributes parse(java.io.InputStream in) throws ParseError
    { return new Parser(in)._Attributes(); }
  public static Attributes parse(String str) throws ParseError
    { return parse(new java.io.StringBufferInputStream(str)); }
}

class TravTag implements Cloneable {
  private Integer integer;
  public Integer get_integer() { return integer; }
  public void set_integer(Integer new_integer)
    { integer = new_integer; }
  TravTag() { }
  public TravTag(Integer integer) {
    super();
    set_integer(integer);
  }
  public static TravTag parse(java.io.InputStream in) throws ParseError
    { return new Parser(in)._TravTag(); }
  public static TravTag parse(String str) throws ParseError
    { return parse(new java.io.StringBufferInputStream(str)); }
}

class IndependantTraversal implements Cloneable {
  private UID sourceid;
  public UID get_sourceid() { return sourceid; }
  public void set_sourceid(UID new_sourceid)
    { sourceid = new_sourceid; }
  private UID destid;
  public UID get_destid() { return destid; }
  public void set_destid(UID new_destid)
    { destid = new_destid; }
  private UID_List bypassings;
  public UID_List get_bypassings() { return bypassings; }
  public void set_bypassings(UID_List new_bypassings)
    { bypassings = new_bypassings; }
  IndependantTraversal() { }
  public IndependantTraversal(UID sourceid, UID destid, UID_List bypassings) {
    super();
    set_sourceid(sourceid);
    set_destid(destid);
    set_bypassings(bypassings);
  }
  public static IndependantTraversal parse(java.io.InputStream in) throws ParseError
    { return new Parser(in)._IndependantTraversal(); }
  public static IndependantTraversal parse(String str) throws ParseError
    { return parse(new java.io.StringBufferInputStream(str)); }
}

class UniqueIDGenerator implements Cloneable {
  public UniqueIDGenerator() {
    super();
  }
  public static UniqueIDGenerator parse(java.io.InputStream in) throws ParseError
    { return new Parser(in)._UniqueIDGenerator(); }
  public static UniqueIDGenerator parse(String str) throws ParseError
    { return parse(new java.io.StringBufferInputStream(str)); }
}

class ReadVertexVisitor implements Cloneable {
  private UGraph thegraph;
  public UGraph get_thegraph() { return thegraph; }
  public void set_thegraph(UGraph new_thegraph)
    { thegraph = new_thegraph; }
  private String graphstring;
  public String get_graphstring() { return graphstring; }
  public void set_graphstring(String new_graphstring)
    { graphstring = new_graphstring; }
  private Integer lookupvid;
  public Integer get_lookupvid() { return lookupvid; }
  public void set_lookupvid(Integer new_lookupvid)
    { lookupvid = new_lookupvid; }
  ReadVertexVisitor() { }
  public ReadVertexVisitor(UGraph thegraph, String graphstring, Integer lookupvid) {
    super();
    set_thegraph(thegraph);
    set_graphstring(graphstring);
    set_lookupvid(lookupvid);
  }
  public static ReadVertexVisitor parse(java.io.InputStream in) throws ParseError
    { return new Parser(in)._ReadVertexVisitor(); }
  public static ReadVertexVisitor parse(String str) throws ParseError
    { return parse(new java.io.StringBufferInputStream(str)); }
  public void before(UConstVertex host) { 
  // if lookupvid is 0 then this traversal was called by PrintVertices
  if (lookupvid.intValue() == 0) {        
    graphstring = graphstring + host.get_vertexname().get_name() + 
      " ";
    graphstring = graphstring + "\t= " ;
    graphstring = graphstring + 
      thegraph.FindEdge(host.get_vid().get_id(), new String("const") );
    graphstring = graphstring + ".\n";
  // else this traversal was called by the EdgeVisitor 
  } else if (host.get_vid().get_id().intValue() == lookupvid.intValue()){
    graphstring = graphstring + host.get_vertexname().get_name() +
      " ";
  }
}
  public void before(UAltVertex host) { 
  // if lookupvid is 0 then this traversal was called by PrintVertices
  if (lookupvid.intValue() == 0) {        
    graphstring = graphstring + host.get_vertexname().get_name() + 
      " ";
    graphstring = graphstring + "\t: " ;
    graphstring = graphstring + 
      thegraph.FindEdge(host.get_vid().get_id(), new String("alt") );
    graphstring = graphstring + ".\n";
  // else this traversal was called by the EdgeVisitor 
  } else if (host.get_vid().get_id().intValue() == lookupvid.intValue()){
    graphstring = graphstring + host.get_vertexname().get_name() +
      " ";
  }
}
}

class ReadEdgeVisitor implements Cloneable {
  private UGraph thegraph;
  public UGraph get_thegraph() { return thegraph; }
  public void set_thegraph(UGraph new_thegraph)
    { thegraph = new_thegraph; }
  private String graphstring;
  public String get_graphstring() { return graphstring; }
  public void set_graphstring(String new_graphstring)
    { graphstring = new_graphstring; }
  private String commonstring;
  public String get_commonstring() { return commonstring; }
  public void set_commonstring(String new_commonstring)
    { commonstring = new_commonstring; }
  private Integer lookupvid;
  public Integer get_lookupvid() { return lookupvid; }
  public void set_lookupvid(Integer new_lookupvid)
    { lookupvid = new_lookupvid; }
  private String fromtype;
  public String get_fromtype() { return fromtype; }
  public void set_fromtype(String new_fromtype)
    { fromtype = new_fromtype; }
  private Integer pipeswitch;
  public Integer get_pipeswitch() { return pipeswitch; }
  public void set_pipeswitch(Integer new_pipeswitch)
    { pipeswitch = new_pipeswitch; }
  ReadEdgeVisitor() { }
  public ReadEdgeVisitor(UGraph thegraph, String graphstring, String commonstring, Integer lookupvid, String fromtype, Integer pipeswitch) {
    super();
    set_thegraph(thegraph);
    set_graphstring(graphstring);
    set_commonstring(commonstring);
    set_lookupvid(lookupvid);
    set_fromtype(fromtype);
    set_pipeswitch(pipeswitch);
  }
  public static ReadEdgeVisitor parse(java.io.InputStream in) throws ParseError
    { return new Parser(in)._ReadEdgeVisitor(); }
  public static ReadEdgeVisitor parse(String str) throws ParseError
    { return parse(new java.io.StringBufferInputStream(str)); }
  public void before(UConstEdge host) { 
  if (host.get_fromVertex().get_id().intValue() == lookupvid.intValue() ) {
    if (fromtype.equals("alt") ) {
      commonstring = commonstring + "<" + host.get_edgename().get_name() +
        "> " ;
      commonstring = commonstring + 
        thegraph.FindVertex(host.get_toVertex().get_id()); 
    } else {
      graphstring = graphstring + "<" + host.get_edgename().get_name() +
        "> " ;
        // now find the toVertex
      graphstring = graphstring + 
        thegraph.FindVertex(host.get_toVertex().get_id()); 
    }
  }    
}
  public void before(UAltEdge host) { 
  if (host.get_fromVertex().get_id().intValue() == lookupvid.intValue() ) {
    if (this.get_pipeswitch().intValue() == 0 ) {
      set_pipeswitch(new Integer(1) );
    } else {
      graphstring = graphstring + "| "; 
    }
    graphstring = graphstring + 
       thegraph.FindVertex(host.get_toVertex().get_id()); 
  }   

}
}

class Main implements Cloneable {
  public Main() {
    super();
  }
  public static Main parse(java.io.InputStream in) throws ParseError
    { return new Parser(in)._Main(); }
  public static Main parse(String str) throws ParseError
    { return parse(new java.io.StringBufferInputStream(str)); }

   public static void main(String args[]) throws Exception
   {
        FileInputStream fi=new FileInputStream("uml.input");
        UGraph graph = UGraph.parse(fi);
        System.out.println(graph.PrintVertices());
   }
}

class Attributes_PList implements Cloneable {
  private Nonempty_Attributes_PList first;
  public Nonempty_Attributes_PList get_first() { return first; }
  public void set_first(Nonempty_Attributes_PList new_first)
    { first = new_first; }
  Attributes_PList() { }
  public Attributes_PList(Nonempty_Attributes_PList first) {
    super();
    set_first(first);
  }
  public static Attributes_PList parse(java.io.InputStream in) throws ParseError
    { return new Parser(in)._Attributes_PList(); }
  public static Attributes_PList parse(String str) throws ParseError
    { return parse(new java.io.StringBufferInputStream(str)); }
}

class UID_List implements Cloneable {
  private Nonempty_UID_List first;
  public Nonempty_UID_List get_first() { return first; }
  public void set_first(Nonempty_UID_List new_first)
    { first = new_first; }
  UID_List() { }
  public UID_List(Nonempty_UID_List first) {
    super();
    set_first(first);
  }
  public static UID_List parse(java.io.InputStream in) throws ParseError
    { return new Parser(in)._UID_List(); }
  public static UID_List parse(String str) throws ParseError
    { return parse(new java.io.StringBufferInputStream(str)); }
}

class Nonempty_UVertex_List implements Cloneable {
  private UVertex it;
  public UVertex get_it() { return it; }
  public void set_it(UVertex new_it)
    { it = new_it; }
  private Nonempty_UVertex_List next;
  public Nonempty_UVertex_List get_next() { return next; }
  public void set_next(Nonempty_UVertex_List new_next)
    { next = new_next; }
  Nonempty_UVertex_List() { }
  public Nonempty_UVertex_List(UVertex it, Nonempty_UVertex_List next) {
    super();
    set_it(it);
    set_next(next);
  }
  public static Nonempty_UVertex_List parse(java.io.InputStream in) throws ParseError
    { return new Parser(in)._Nonempty_UVertex_List(); }
  public static Nonempty_UVertex_List parse(String str) throws ParseError
    { return parse(new java.io.StringBufferInputStream(str)); }
  public void ReadAllVertices_trv1(ReadVertexVisitor rvv) {
    it.ReadAllVertices_trv1(rvv);
    if (next != null) {
      next.ReadAllVertices_trv1(rvv);
    }
  }
}

class Nonempty_IEdge_List implements Cloneable {
  private UID it;
  public UID get_it() { return it; }
  public void set_it(UID new_it)
    { it = new_it; }
  private Nonempty_IEdge_List next;
  public Nonempty_IEdge_List get_next() { return next; }
  public void set_next(Nonempty_IEdge_List new_next)
    { next = new_next; }
  Nonempty_IEdge_List() { }
  public Nonempty_IEdge_List(UID it, Nonempty_IEdge_List next) {
    super();
    set_it(it);
    set_next(next);
  }
  public static Nonempty_IEdge_List parse(java.io.InputStream in) throws ParseError
    { return new Parser(in)._Nonempty_IEdge_List(); }
  public static Nonempty_IEdge_List parse(String str) throws ParseError
    { return parse(new java.io.StringBufferInputStream(str)); }
}

class Nonempty_OEdge_List implements Cloneable {
  private UID it;
  public UID get_it() { return it; }
  public void set_it(UID new_it)
    { it = new_it; }
  private Nonempty_OEdge_List next;
  public Nonempty_OEdge_List get_next() { return next; }
  public void set_next(Nonempty_OEdge_List new_next)
    { next = new_next; }
  Nonempty_OEdge_List() { }
  public Nonempty_OEdge_List(UID it, Nonempty_OEdge_List next) {
    super();
    set_it(it);
    set_next(next);
  }
  public static Nonempty_OEdge_List parse(java.io.InputStream in) throws ParseError
    { return new Parser(in)._Nonempty_OEdge_List(); }
  public static Nonempty_OEdge_List parse(String str) throws ParseError
    { return parse(new java.io.StringBufferInputStream(str)); }
}

class Nonempty_UEdge_List implements Cloneable {
  private UEdge it;
  public UEdge get_it() { return it; }
  public void set_it(UEdge new_it)
    { it = new_it; }
  private Nonempty_UEdge_List next;
  public Nonempty_UEdge_List get_next() { return next; }
  public void set_next(Nonempty_UEdge_List new_next)
    { next = new_next; }
  Nonempty_UEdge_List() { }
  public Nonempty_UEdge_List(UEdge it, Nonempty_UEdge_List next) {
    super();
    set_it(it);
    set_next(next);
  }
  public static Nonempty_UEdge_List parse(java.io.InputStream in) throws ParseError
    { return new Parser(in)._Nonempty_UEdge_List(); }
  public static Nonempty_UEdge_List parse(String str) throws ParseError
    { return parse(new java.io.StringBufferInputStream(str)); }
  public void ReadAllEdges_trv2(ReadEdgeVisitor rev) {
    it.ReadAllEdges_trv2(rev);
    if (next != null) {
      next.ReadAllEdges_trv2(rev);
    }
  }
}

class Nonempty_Attributes_PList implements Cloneable {
  private Attributes it;
  public Attributes get_it() { return it; }
  public void set_it(Attributes new_it)
    { it = new_it; }
  private Nonempty_Attributes_PList next;
  public Nonempty_Attributes_PList get_next() { return next; }
  public void set_next(Nonempty_Attributes_PList new_next)
    { next = new_next; }
  Nonempty_Attributes_PList() { }
  public Nonempty_Attributes_PList(Attributes it, Nonempty_Attributes_PList next) {
    super();
    set_it(it);
    set_next(next);
  }
  public static Nonempty_Attributes_PList parse(java.io.InputStream in) throws ParseError
    { return new Parser(in)._Nonempty_Attributes_PList(); }
  public static Nonempty_Attributes_PList parse(String str) throws ParseError
    { return parse(new java.io.StringBufferInputStream(str)); }
}

class Nonempty_UID_List implements Cloneable {
  private UID it;
  public UID get_it() { return it; }
  public void set_it(UID new_it)
    { it = new_it; }
  private Nonempty_UID_List next;
  public Nonempty_UID_List get_next() { return next; }
  public void set_next(Nonempty_UID_List new_next)
    { next = new_next; }
  Nonempty_UID_List() { }
  public Nonempty_UID_List(UID it, Nonempty_UID_List next) {
    super();
    set_it(it);
    set_next(next);
  }
  public static Nonempty_UID_List parse(java.io.InputStream in) throws ParseError
    { return new Parser(in)._Nonempty_UID_List(); }
  public static Nonempty_UID_List parse(String str) throws ParseError
    { return parse(new java.io.StringBufferInputStream(str)); }
}

