package org.webjinn.cms.model;

/** Represents Item element of the interface tree */
public interface Item
	extends CMSTreeNode, InterfaceTreeElement, AttributeContainer {
	
  /** Returns associated (parent) Menu element (if any) */
  public Menu getParentMenu();

  /** Returns nested (child) Menu element */
  public Menu getChildMenu(); 	

  /** Creates new Menu element and associates it with this Item element 
	 * (adds the Menu element as a child of the Item element) 
	 * Does nothing if the Item element is already 
	 * associated with a Menu element */
  public void associate(String menuName); 	

	/** Disconnects child Menu element from this Item.
	 * Child Menu is then removed from the tree */
  public void disassociate();

	/** Moves this Item element one position up or down 
	 * relatively to its siblings */
	public void moveItem(boolean up);
	
}
