package org.webjinn.cms.model;

/** Represents container that is 
 * able to store css files collection */
public interface CSSFilesContainer {

	/** Retrieves a list of attributes stored in the container */
	public CSSFile[] getCSSFiles();

	/** Retrieves a CSSFile object by its url from the container */
	public CSSFile getCSSFile(String url);

	/** Creates CSS file using url provided and 
	 * places it in the container */
	public void addCSSFile(String url);

	/** Removes a CSSFile from the container.
	 * Does nothing if argument CSSFile is not found
	 * in the container */
	public void removeCSSFile(CSSFile cssfile);

}
