package org.webjinn.cms.model;

/** Provides access to the CMS tree */
public interface CMSTree {

  /** Retrieves array of interfaces */	
	public Interface[] getInterfaces();

	/** Retrieves Interface by name */
	public Interface getInterface(String name);

	/** Adds a new interface to the tree.
	 * Interface name provide must be not null, not empty and
	 * unique among interfaces already in the tree */
	public void addInterface(String name, String descr);

  /** Removes an interface from the tree. 
	 * Do nothing if Interface object provided is not
	 * found in the tree */
	public void removeInterface(Interface in);

	/** Given an interface-uri string returns corresponding tree element 
	 * or null if not found */
	public InterfaceTreeElement resolveInterfaceURI(String uri);

	/** Retrieves array of pages */
	public Page[] getPages();	

	/** Returns Page object by file URI.
	 * Returns null if argument doesn't resolve any page in the tree 
	 * or argument is null. */
	public Page getPage(String fileURI);

	/** Retrieves array of Pages 
	 * associated with element specified by the interfaceURI argument.
	 *  If there are no such Pages exists, returns array of size 0 
	 *  (Here uri may resolve not only menus and items but an interface as well.
	 *  If interfaceURI is null or empty string, all pages in the tree 
	 *  are returned) */
	public Page[] getAssociatedPages(String interfaceURI);	

	/** Returns array of Pages associated with a tree 
	 * element specified by the interfaceURI argument or with any 
	 * of its descendants.
	 * (Here uri may resolve not only menus and items but an interface as well.
	 * If interfaceURI is null or empty string, all pages in the tree 
	 *  are returned) */
 	public Page[] getRelatedPages(String interfaceURI);	

	/** Retrieves array of Pages associated with files 
	 * located in the directory specified by argument fileURI. 
	 * if includeSubDirs argument is true, then method recurse
	 * on subdirs of the directory specified by fileURI */
	public Page[] getDirectoryPages(String fileURI, boolean recurseOnSubDirs);

  /** Adds new page information to the tree. */
  public void addPage(String fileURI, String menuURI);

  /** Removes a page from the tree. Does nothing if
	 * this page object is not found in the tree or argument is null.*/
	public void removePage(Page page);

  /** Removes an array of pages from the tree.
	 * Do nothing if argument is null. 
	 * Do nothing for page objects that are not found in the tree
	 * Semantically identical to the operation, that applies removePage 
	 * method to each object from the argument array. */
	public void removePages(Page[] pages);
	

	/** Returns absolute file path of a web-site root dir on the server */ 
	public String getRootDir();

}
