package org.webjinn.cms.actions;
import org.apache.struts.action.*;
import org.webjinn.cms.model.CMSTree;
import org.webjinn.cms.model.Page;
import org.webjinn.cms.model.FileUtils;
import org.webjinn.cms.model.weaver.TextProcessingUtils;

/** Generates headers and footers for all the pages */
public class WrapAction extends CMSAction {

	public ActionForward execute(ActionMapping mapping,
			ActionForm form,
			javax.servlet.http.HttpServletRequest request,
			javax.servlet.http.HttpServletResponse response)
		throws java.lang.Exception {
		try{
			CMSTree tree = getCMSTree();
			Page[] pages = tree.getPages();
			for(int i=0;i<pages.length;i++) 
				FileUtils.setPageContent(pages[i], TextProcessingUtils.wrap(pages[i]));
			return mapping.findForward("SUCCESS");
		} catch (Exception e) {
			request.setAttribute("exception", e);
			return mapping.findForward("FAIL");
		}
	}

}
