package org.webjinn.cms.actions;
import org.apache.struts.action.*;
import org.webjinn.cms.model.CMSTree;
import org.webjinn.cms.model.Menu;
import org.webjinn.cms.model.FileUtils;
import org.webjinn.cms.model.weaver.TextProcessingUtils;
import org.webjinn.cms.model.Page;
import java.util.Vector;
import java.io.File;


/** Updates a content of CMS code container (Page or Menu) */
public class UpdateContentAction extends CMSAction {

	public ActionForward execute(ActionMapping mapping,
			ActionForm form,
			javax.servlet.http.HttpServletRequest request,
			javax.servlet.http.HttpServletResponse response)
		throws java.lang.Exception {
		try{
			CMSTree tree = getCMSTree();
			String rootDir = Utils.getRootDir(tree);
			String conttype = request.getParameter("conttype");
			String uri = request.getParameter("uri");
			String content=request.getParameter("content");
                        String part = request.getParameter("part");
			if (conttype.equals("menu")) {
				Menu menu = (Menu)tree.resolveInterfaceURI(uri);	
				if (part.equals("header")) 
					menu.setHeader(content);
				if (part.equals("footer")) {
					menu.setFooter(content);
				}
			}
			if (conttype.equals("page")) {
				Page page = tree.getPage(uri);
				FileUtils.setPageContent(page,content);
				FileUtils.setPageContent(page,TextProcessingUtils.wrap(page));
			}
			if (conttype.equals("file")) {
			  String fileURI=rootDir+File.separator+Utils.normalizeFileURI(uri);
			  FileUtils.setFileContent(fileURI,content);
			}
			MappedBean record = new MappedBean();
			record.setValue("conttype",conttype);
			record.setValue("uri",uri);
                        if (part!=null) record.setValue("part",part);
			record.setValue("content",content);
			request.setAttribute("record",record);
			return mapping.findForward("CONTENT");
		} catch (Exception e) {
			request.setAttribute("exception", e);
			return mapping.findForward("EXCEPTION");
		}

	}
}
