package org.webjinn.cms.actions;
import org.apache.struts.action.*;
import org.webjinn.cms.model.weaver.*;
import org.webjinn.cms.model.CMSTree;
import org.webjinn.cms.model.Item;
import org.webjinn.cms.model.Menu;
import org.webjinn.cms.model.InterfaceTreeElement;
import org.webjinn.cms.model.Page;
import org.webjinn.cms.model.Attribute;
import org.webjinn.cms.model.AttributeContainer;
import java.util.Vector;
import java.util.HashSet;
import java.util.Enumeration;
import java.util.Map;

/** Updates a set of attributes */
public class UpdateAttributesAction extends CMSAction {


	public ActionForward execute(ActionMapping mapping,
			ActionForm form,
			javax.servlet.http.HttpServletRequest request,
			javax.servlet.http.HttpServletResponse response)
		throws java.lang.Exception {
		try{
			String conttype = request.getParameter("conttype");
			String uri = request.getParameter("uri");
			CMSTree tree = getCMSTree();
			String text="";
			String attrTagName=null;
			AttributeContainer cont=null;
			if (conttype.equals("menu")) {
				Menu menu = (Menu)tree.resolveInterfaceURI(uri);
				text = menu.getHeader()+menu.getFooter();
				attrTagName=Constants.MenuAttributeTag;
				cont=menu;
			}
			if (conttype.equals("item")) {
				Item item = (Item)tree.resolveInterfaceURI(uri);
				attrTagName=Constants.ItemAttributeTag;
				Menu menu = item.getParentMenu();
				text = menu.getHeader()+menu.getFooter();
				cont=item;
			}
			if (conttype.equals("page")) {
				Page page = tree.getPage(uri);
				attrTagName=Constants.PageAttributeTag;
				Menu menu;
				InterfaceTreeElement el = page.getAssociatedElement();
				if (el instanceof Menu) 
					menu=(Menu)el;
				else
					menu=((Item)el).getParentMenu();
				StringBuffer textsb = new StringBuffer();	
				while(menu!=null)	{
					textsb.append(menu.getHeader());
					textsb.append(menu.getFooter());
					if (menu.getParentItem()!=null)
						menu=menu.getParentItem().getParentMenu();
					else
						menu=null;
				}
				text=textsb.toString();
				cont=page;
			}	
			AttributeTag[] tags = TextProcessingUtils.getAttributes(text,attrTagName);
			Map params = request.getParameterMap();
			for(int i=0;i<tags.length;i++) {
				String attrName = tags[i].getName();
				Attribute attribute = cont.getAttribute(attrName);
				if (attribute!=null) cont.removeAttribute(attribute);
				String value = request.getParameter("attr_"+attrName);
				if (value!=null) {
					cont.addAttribute(attrName,null,value);
				}
			}
			
      return mapping.findForward("SUCCESS");
		} catch (Exception e) {
			request.setAttribute("exception", e);
			return mapping.findForward("FAIL");
		}
	}

}
