package org.webjinn.cms.actions;
import org.apache.struts.action.*;
import org.webjinn.cms.model.CMSTree;
import org.webjinn.cms.model.Interface;
import org.webjinn.cms.model.Item;
import org.webjinn.cms.model.Menu;

import java.util.Vector;

/** Obtains items tree under the Interface specified within request.
 * Returns a set of records, one per item.
 * Each such a record specifies:
 * (1) if this item has associated menu
 * (2) The number of the associated menu child items
 *     (0 if no menu is associated)
 * (3) Associated menu name
 * (4) Associated menu URI
 * (5) Item name
 * (6) Item URI
 * (7) Item level  
 * For the first record, there is no item, so there is no
 * Item-associated data (Item name and Item URI are null) */
public class SelectItemsAction extends CMSAction {

	public ActionForward execute(ActionMapping mapping,
			ActionForm form,
			javax.servlet.http.HttpServletRequest request,
			javax.servlet.http.HttpServletResponse response)
		throws java.lang.Exception {
		try{
			//MappedBean beanForm = (MappedBean)form;
			//String interfaceName = (String)beanForm.getValue("interface");
			String interfaceName = request.getParameter("interface");
			CMSTree tree = getCMSTree();
			Interface intface = tree.getInterface(interfaceName);
			Vector result = new Vector();
			Menu menu = intface.getRootMenu();
			MappedBean record = new MappedBean();			
		  record.setValue("ItemLevel", new Integer(0));
		  record.setValue("hasMenu","true");		
			setMenuData(menu,record);
      Item[] children = menu.getChildItems();			
      record.setValue("ChildrenNum",new Integer(children.length));			
			result.add(record);
	    for (int i=0;i<children.length;i++)		
		   addItem(children[i],result,1);	

			request.setAttribute("messages",result);
			return mapping.findForward("CONTENT");
		} catch (Exception e) {
				request.setAttribute("exception", e);
        return mapping.findForward("EXCEPTION");
			}
	}

	private void setMenuData(Menu menu, MappedBean record) {
		if (menu==null) return;
		record.setValue("MenuName",menu.getName());
		record.setValue("MenuURI",menu.getInterfaceURI());
	}

	private void addItem(Item item, Vector result, int level) {
		if (item==null) return;
		MappedBean record = new MappedBean();			
		record.setValue("ItemLevel", new Integer(level));
		record.setValue("ItemName", item.getName());
		record.setValue("ItemURI", item.getInterfaceURI());
	  Menu menu = item.getChildMenu();
	  if (menu==null) {
			record.setValue("ChildrenNum",new Integer(0));
			record.setValue("hasMenu","false");
	    result.add(record);
		}	else {
			record.setValue("hasMenu","true");			
			setMenuData(menu,record);
      Item[] children = menu.getChildItems();			
      record.setValue("ChildrenNum",new Integer(children.length));
			result.add(record);
			level = level+1;
		  for (int i=0;i<children.length;i++)
			  addItem(children[i], result, level);	
		}
	}
}
