package org.webjinn.cms.actions;
import org.apache.struts.action.*;
import org.webjinn.cms.model.CMSTree;
import org.webjinn.cms.model.Interface;
import java.util.Vector;

/** Retrieves a set of Interface objects from the CMS Tree */
public class SelectInterfacesAction extends CMSAction {

	public ActionForward execute(ActionMapping mapping,
			ActionForm form,
			javax.servlet.http.HttpServletRequest request,
			javax.servlet.http.HttpServletResponse response)
		throws java.lang.Exception {
		try{
			//MappedBean beanForm = (MappedBean)form;
			CMSTree tree = getCMSTree();
			Interface[] interfaces = tree.getInterfaces();
			Vector result = new Vector();
			for (int i=0;i<interfaces.length;i++) {
				MappedBean record = new MappedBean();			
				String name = interfaces[i].getName();
				record.setValue("name",name);	
				String descr = interfaces[i].getDescription();
				if (descr==null) descr="";
				record.setValue("description",descr);	
				result.add(record);
			}
			request.setAttribute("messages",result);
			return mapping.findForward("CONTENT");
		} catch (Exception e) {
			request.setAttribute("exception", e);
			return mapping.findForward("EXCEPTION");
		}
	}
}
