package org.webjinn.cms.actions;
import org.apache.struts.action.*;
import org.webjinn.cms.model.CMSTree;
import org.webjinn.cms.model.Page;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class SelectDirsAction extends CMSAction {

	public ActionForward execute(ActionMapping mapping,
			ActionForm form,
			javax.servlet.http.HttpServletRequest request,
			javax.servlet.http.HttpServletResponse response)
		throws java.lang.Exception {
		try{
			CMSTree tree = getCMSTree();	
      String rootDir = Utils.getRootDir(tree);
			String uri = request.getParameter("uri");
			String fileURI = Utils.normalizeFileURI(uri);
			
			Vector result = new Vector();
			setDirectories(rootDir,fileURI,result);
			request.setAttribute("messages",result);
			return mapping.findForward("CONTENT");
		} catch (Exception e) {
				request.setAttribute("exception", e);
        return mapping.findForward("EXCEPTION");
			}
	}

	  private void setDirectories(String rootDir,String uri,Vector records) throws IOException {
    MappedBean record=new MappedBean();
    record.setValue("name","ROOT");
    record.setValue("path","ROOT");
    record.setValue("isparent","true");
    records.add(record);

    if (uri!=null && uri.length()>1) {
      StringTokenizer parents=new StringTokenizer(uri,File.separator);
      String path="ROOT";
      if (parents!=null) 
      while (parents.hasMoreTokens()) {
        String name=parents.nextToken();
        path=path+"/"+name;
        record=new MappedBean();
        record.setValue("name",name);
        record.setValue("path",path);
        record.setValue("isparent","true");
        records.add(record);
      }
    }

    File[] files = new File(rootDir+File.separator+uri).listFiles();
		System.err.println(files);
		for (int i=0;i<files.length;i++)
			if (files[i].isDirectory()) {
				record=new MappedBean();
    		System.err.println(files[i].getName());
				record.setValue("name",files[i].getName());
				record.setValue("path",Utils.getRequestURI(rootDir,files[i]));
				record.setValue("isparent","false");
				records.add(record);
			}
  }
	
	
}
