package org.webjinn.cms.actions;
import org.apache.struts.action.*;
import org.webjinn.cms.model.CMSTree;
import org.webjinn.cms.model.Menu;
import org.webjinn.cms.model.Page;
import org.webjinn.cms.model.CSSFile;
import org.webjinn.cms.model.CSSFilesContainer;
import java.util.Vector;

/** Returns a list of cssfiles associated with a
 * CSSFilesContainer (Menu or Page) specified by uri */
public class SelectCSSFilesAction extends CMSAction {

	public ActionForward execute(ActionMapping mapping,
			ActionForm form,
			javax.servlet.http.HttpServletRequest request,
			javax.servlet.http.HttpServletResponse response)
		throws java.lang.Exception {
		try{
			String conttype = request.getParameter("conttype");
			String uri = request.getParameter("uri");
			CMSTree tree = getCMSTree();
			CSSFilesContainer cont=null;
			if (conttype.equals("menu"))
				cont = (Menu)tree.resolveInterfaceURI(uri);

			if (conttype.equals("page")) 
				cont = tree.getPage(uri);

      CSSFile[] cssfiles = cont.getCSSFiles();

			Vector result = new Vector();
			for (int i=0;i<cssfiles.length;i++) {
				String url = cssfiles[i].getURL();
				MappedBean record = new MappedBean();			
				record.setValue("url", url);
				result.add(record);					
			}

			request.setAttribute("cssfiles",result);
			return mapping.findForward("CONTENT");
		} catch (Exception e) {
			request.setAttribute("exception", e);
			return mapping.findForward("EXCEPTION");
		}
	}

}
