package org.webjinn.cms.actions;
import org.apache.struts.action.*;
import org.webjinn.cms.model.CMSTree;
import org.webjinn.cms.model.Item;
import org.webjinn.cms.model.Menu;
import org.webjinn.cms.model.Page;
import org.webjinn.cms.model.Attribute;
import org.webjinn.cms.model.AttributeContainer;
import org.webjinn.cms.model.InterfaceTreeElement;

import org.webjinn.cms.model.weaver.*;

import java.util.Vector;
import java.util.HashSet;

/** Retrieves set of attributes (by parsing header(s) and footer(s))
 * associated with the attribute container (page, item or menu).
 * Attribute values are obtained from CMS tree */
public class SelectAttributesAction extends CMSAction {

	public ActionForward execute(ActionMapping mapping,
			ActionForm form,
			javax.servlet.http.HttpServletRequest request,
			javax.servlet.http.HttpServletResponse response)
		throws java.lang.Exception {
		try{
			String conttype = request.getParameter("conttype");
			String uri = request.getParameter("uri");
			CMSTree tree = getCMSTree();
			String text="";
			String attrTagName=null;
			AttributeContainer cont=null;
			if (conttype.equals("menu")) {
				Menu menu = (Menu)tree.resolveInterfaceURI(uri);
				text = menu.getHeader()+menu.getFooter();
				attrTagName=Constants.MenuAttributeTag;
				cont=menu;
			}
			if (conttype.equals("item")) {
				Item item = (Item)tree.resolveInterfaceURI(uri);
				attrTagName=Constants.ItemAttributeTag;
				Menu menu = item.getParentMenu();
				text = menu.getHeader()+menu.getFooter();
				cont=item;
			}
			if (conttype.equals("page")) {
				Page page = tree.getPage(uri);
				attrTagName=Constants.PageAttributeTag;
				Menu menu;
				InterfaceTreeElement el = page.getAssociatedElement();
				if (el instanceof Menu) 
					menu=(Menu)el;
				else
					menu=((Item)el).getParentMenu();
				StringBuffer textsb = new StringBuffer();	
				while(menu!=null)	{
					textsb.append(menu.getHeader());
					textsb.append(menu.getFooter());
					if (menu.getParentItem()!=null)
						menu=menu.getParentItem().getParentMenu();
					else
						menu=null;
				}
				text=textsb.toString();
				cont=page;
			}	
			AttributeTag[] tags = TextProcessingUtils.getAttributes(text,attrTagName);
			Vector result = new Vector();
			HashSet required = new HashSet();
			for (int i=0;i<tags.length;i++) {
				AttributeTag tag=tags[i];
				MappedBean record = new MappedBean();			
				record.setValue("name", tag.getName());
				required.add(tag.getName());
				record.setValue("htmltype", tag.getHTMLType());
				record.setValue("description", tag.getDescription());
				record.setValue("type","required");
				Attribute attr = cont.getAttribute(tag.getName());
				if (attr!=null) {
					record.setValue("value",attr.getValue());
				}
				result.add(record);
			}
			// Do I need it?
			Attribute[] attrs = cont.getAttributes();
			for (int i=0;i<attrs.length;i++) {
				String name = attrs[i].getName();
				if (!required.contains(name)) {
					MappedBean record = new MappedBean();			
					record.setValue("name", attrs[i].getName());
					record.setValue("htmltype", "text");
					record.setValue("type","complementary");
					record.setValue("value",attrs[i].getValue());
					result.add(record);					
				}
			}
			request.setAttribute("attributes",result);
			return mapping.findForward("CONTENT");
		} catch (Exception e) {
			request.setAttribute("exception", e);
			return mapping.findForward("EXCEPTION");
		}
	}

}
