package org.webjinn.cms.actions;
import org.apache.struts.action.*;
import org.webjinn.cms.model.CMSTree;
import org.webjinn.cms.model.Menu;
import org.webjinn.cms.model.Page;
import org.webjinn.cms.model.FileUtils;
import java.util.Vector;
import java.io.File;

/** Retrieves a content of CMS code container (Page or Menu) */
public class GetContentAction extends CMSAction {

	public ActionForward execute(ActionMapping mapping,
			ActionForm form,
			javax.servlet.http.HttpServletRequest request,
			javax.servlet.http.HttpServletResponse response)
		throws java.lang.Exception {
		try{
			CMSTree tree = getCMSTree();
			String rootDir = Utils.getRootDir(tree);
			String conttype = request.getParameter("conttype");
			String uri = request.getParameter("uri");
			String content="";
			MappedBean record = new MappedBean();
			if (conttype.equals("menu")) {
				Menu menu = (Menu)tree.resolveInterfaceURI(uri);	
				String part = request.getParameter("part");
				if (part.equals("header")) {
					content = menu.getHeader();
				}
				if (part.equals("footer")) {
					content = menu.getFooter();
				}
				record.setValue("part",part);
			}
			if (conttype.equals("page")) {
				Page page = tree.getPage(uri);
				content = FileUtils.getPageContent(page);
			}
			if (conttype.equals("file")) {
			  String fileURI=rootDir+File.separator+Utils.normalizeFileURI(uri);
			  content = FileUtils.getFileContent(fileURI);
			}
			record.setValue("conttype",conttype);
			record.setValue("uri",uri);
			record.setValue("content",content);
			request.setAttribute("record",record);
			return mapping.findForward("CONTENT");
		} catch (Exception e) {
			request.setAttribute("exception", e);
			return mapping.findForward("EXCEPTION");
		}

	}
}
