package org.webjinn.cms.actions;
import org.apache.struts.action.*;
import org.webjinn.cms.model.CMSTree;
import org.webjinn.cms.model.Page;

/** Removes a Page from the CMS tree */
public class DisAssociateAction extends CMSAction {

	public ActionForward execute(ActionMapping mapping,
			ActionForm form,
			javax.servlet.http.HttpServletRequest request,
			javax.servlet.http.HttpServletResponse response)
		throws java.lang.Exception {
		try{
			String pageURI = request.getParameter("pageuri");
			CMSTree tree = getCMSTree();
			Page page = tree.getPage(pageURI);
			if (page!=null) tree.removePage(page);
			return mapping.findForward("SUCCESS");
		} catch (Exception e) {
			request.setAttribute("exception", e);
			return mapping.findForward("FAIL");
		}
	}

}
